unit dpmitype;
interface
{WinAPI begin}
{#Z+}
{ Generic types }

type
  Bool     = WordBool;          { Windows compatible boolean }
  THandle  = Word;              { Global memory handle }
  TFarProc = Pointer;           { Procedure address }

{ Flags returned by GetWinFlags }

const
  wf_PMode      = $00000001;    { Running in protected mode }
  wf_CPU286     = $00000002;    { System CPU is an 80286 }
  wf_CPU386     = $00000004;    { System CPU is an 80386 }
  wf_CPU486     = $00000008;    { System CPU is an 80486 }
  wf_Standard   = $00000010;    { Running in standard mode }
  wf_Enhanced   = $00000020;    { Running in enhanced mode }
  wf_CPU086     = $00000040;    { System CPU is an 8086 }
  wf_CPU186     = $00000080;    { System CPU is an 80186 }
  wf_LargeFrame = $00000100;    { Windows EMS large-frame configuration }
  wf_SmallFrame = $00000200;    { Windows EMS small-frame configuration }
  wf_80x87      = $00000400;    { System contains a math coprocessor }
  wf_DPMI       = $80000000;    { Running in DOS protected mode }

{ GlobalAlloc and GlobalReAlloc flags }

const
  gmem_Fixed       = $0000;     { Allocate fixed memory }
  gmem_Moveable    = $0002;     { Allocate moveable memory }
  gmem_NoCompact   = $0010;     { Don't compact when allocating }
  gmem_NoDiscard   = $0020;     { Don't discard when allocating }
  gmem_ZeroInit    = $0040;     { Initialize memory contents to zero }
  gmem_Modify      = $0080;     { Modify memory flags }
  gmem_Discardable = $0100;     { Allocate discardable memory }
  gmem_Not_Banked  = $1000;     { Allocate non-banked memory }
  gmem_DDEShare    = $2000;     { Allocate sharable memory }
  gmem_Notify      = $4000;     { Notify upon discarding }

{ Flags returned by GlobalFlags (in addition to gmem_Discardable) }

const
  gmem_Discarded = $4000;
  gmem_LockCount = $00FF;

{ MessageBox Flags }

const
  mb_Ok               = $0000;
  mb_OkCancel         = $0001;
  mb_AbortRetryIgnore = $0002;
  mb_YesNoCancel      = $0003;
  mb_YesNo            = $0004;
  mb_RetryCancel      = $0005;

  mb_IconHand         = $0010;
  mb_IconStop         = $0010;
  mb_IconQuestion     = $0020;
  mb_IconExclamation  = $0030;
  mb_IconAsterisk     = $0040;
  mb_IconInformation  = $0040;

  mb_DefButton1       = $0000;
  mb_DefButton2       = $0100;
  mb_DefButton3       = $0200;

  mb_ApplModal        = $0000;
  mb_SystemModal      = $1000;
  mb_TaskModal        = $2000;

  mb_NoFocus          = $8000;

  mb_TypeMask         = $000F;
  mb_IconMask         = $00F0;
  mb_DefMask          = $0F00;
  mb_ModeMask         = $3000;
  mb_MiscMask         = $C000;

{ MessageBox return values }

const
  id_Ok     = 1;
  id_Cancel = 2;
  id_Abort  = 3;
  id_Retry  = 4;
  id_Ignore = 5;
  id_Yes    = 6;
  id_No     = 7;
{/WinAPI end}
implementation
end.