unit editypes;
{$I define.pas}
interface
uses Objects, WinTypes;
const
  cmCut         = 20;
  cmCopy        = 21;
  cmPaste       = 22;
  cmUndo        = 23;
  cmClear       = 24;

  cmSave        = 80;
  cmSaveAs      = 81;
  cmFind        = 82;
  cmReplace     = 83;
  cmSearchAgain = 84;

const
  cmCharLeft    = 500;
  cmCharRight   = 501;
  cmWordLeft    = 502;
  cmWordRight   = 503;
  cmLineStart   = 504;
  cmLineEnd     = 505;
  cmLineUp      = 506;
  cmLineDown    = 507;
  cmPageUp      = 508;
  cmPageDown    = 509;
  cmTextStart   = 510;
  cmTextEnd     = 511;
  cmNewLine     = 512;
  cmBackSpace   = 513;
  cmDelChar     = 514;
  cmDelWord     = 515;
  cmDelStart    = 516;
  cmDelEnd      = 517;
  cmDelLine     = 518;
  cmInsMode     = 519;
  cmStartSelect = 520;
  cmHideSelect  = 521;
  cmIndentMode  = 522;
  cmUpdateTitle = 523;
{2}cmNewField    = 524;
const
  edOutOfMemory   = 0;
  edReadError     = 1;
  edWriteError    = 2;
  edCreateError   = 3;
  edSaveModify    = 4;
  edSaveUntitled  = 5;
  edSaveAs        = 6;
  edFind          = 7;
  edSearchFailed  = 8;
  edReplace       = 9;
  edReplacePrompt = 10;

const
  efCaseSensitive   = $0001;
  efWholeWordsOnly  = $0002;
  efPromptOnReplace = $0004;
  efReplaceAll      = $0008;
  efDoReplace       = $0010;
  efBackupFiles     = $0100;
  efStripLetters    = $0200;

const
  CIndicator = #2#3;
  CEditor    = #6#7;
  CMemo      = #26#27;

const
  MaxLineLength = 256;

  HeapSize = 32 * (1024 div 16);


type
  TEditorDialog = function(Dialog: Integer; Info: Pointer): Word;

type
  PEditBuffer = ^TEditBuffer;
  TEditBuffer = array[0..65519] of Char;

type
  TMemoData = record
    Length: Word;
    Buffer: TEditBuffer;
  end;
  TFindStr = String[80];

function DefEditorDialog(Dialog: Integer; Info: Pointer): Word;

const
  WordChars: set of Char = ['0'..'9', 'A'..'Z', '_', 'a'..'z'];
  EditorDialog: TEditorDialog = DefEditorDialog;{redefine in application}
  EditorFlags: Word = efBackupFiles + efPromptOnReplace;
  FindStr: TFindStr = '';
  ReplaceStr: TFindStr = '';
  NewFieldChar= #30;
  CRLFChar= #29;

  nsNewSearch    = 0;   {ns - next search}
  nsWiderSearch  = 1;
  nsNarrowSearch = 2;
  NextSearchFlags: Word = nsNewSearch;

type

  TFindDialogRec = record
    Find: TFindStr;
    Options: Word;
    NextSearchOptions: Word {only for search in sfcollection}
  end;
{
  efCaseSensitive   = $0001;
  efWholeWordsOnly  = $0002;
  efPromptOnReplace = $0004;
  efReplaceAll      = $0008;
  efDoReplace       = $0010;
  efBackupFiles     = $0100;

  nsNewSearch    = 0;
  nsWiderSearch  = 1;
  nsNarrowSearch = 2;
}

type
  TReplaceDialogRec = record
    Find: TFindStr;
    Replace: TFindStr;
    Options: Word;
  end;

implementation
function DefEditorDialog(Dialog: Integer; Info: Pointer): Word;
begin
  DefEditorDialog := IDCancel;
end;

end.