unit iotype;{ io specific errors from 500..}
{$i define.pas}
interface
uses MyType;

const
  msPerTick = 55;{miliseconds per system timer tick}
  MaxIOs = 16;{com ports, ipx modul}
  MaxIOBufSize = mytype .MaxBufSize;
  DefIOBufSize = 1024;

type
  TIONum = integer;
  PIONum = ^TIONum;

  TIOMode = word;

  PHIO = ^THIO;
  THIO = integer;{Handle to IO: index in iou.ioarray : open devices array}

  TIOBuf = TBuf;{array [0..MaxIOBufSize - 1] of byte;}
  PIOBuf = PBuf;{.. if you change this, change also mylib.ChangeBuffer}
  TIOBufSize = TBufSize;

  TIOName = string;
  TIOError = integer;
  TIOResult = integer;
  TIOProperty = integer;
  TIOType = byte;

{ IOResults - IOErrors irXXXX }
const
  NoHIO = 0;{assign to non initialized THIO variables}

  AllFiles = -2;{handles for broadcasting to all ports}
  AllCOMs = -4;
  AllHIOs = -(abs(AllFiles) or abs(AllCOMs));

  irError = -1;{unknown error}
  irOK = 0;
  irFileNotFound = 2;
  irPathNotFound = 3;
  irAccessDenied = 5; { trying to write to file open just for reading }
  irInvalidHandle = 6;
  irNotEnoughMemory = 8;
  irInvalidEnvironment = 10;
  irInvalidFormat = 11;
  irNoMoreFiles = 18;

  irDiskReadError = 100; { trying to read beyond the end of stream }
  irDiskWriteError = 101; { disk full }
  irFileNotAssigned = 102;
  irFileNotOpen = 103;
  irFileNotOpenForInput = 104;
  irFileNotOpenForOutput = 105;
  irInvalidNumericFormat = 106;

  irDiskIsWriteProtected = 150;
  irBadDriveRequestStructLength = 151;
  irDriveNotReady = 152;
  irCRCErrorInData = 154;
  irDiskSeekError = 156;
  irUnknownMediaType = 157;
  irSectorNotFound = 158;
  irPrinterOutOfPaper = 159;
  irDeviceWriteFault = 160;
  irDeviceReadFault = 161;
  irHardwareFailure = 162;

  irCOMReceiveBufferEmpty = 500; {for comport}
  {..used also for other devices than files}
  irInvalidGetProperty = 501;
  irInvalidSetProperty = 502;
  irInvalidIOType = 503;
  irTooManyIOHandles = 504; {table of ioinfo is full, can't open more ios}

  {ioErrors
  eioOutOfMemory = -1;
  eioRcvBufOverflow = -2;
  eioInvalidPort = -3;}

  {TReceiveProc = procedure(AIO:TIO; Buf:PIOBuf; Size:TIOBufSize);{call back function
    prototype, owner of the IO can register it to be called by
    the port after receiving of some number (can be specified) of bytes}

{ TStream access modes (IO access modes), use together with
  FileMode - filesharing constants below }
(* see TVType

  stCreate    = $3C00;           { Create new file }
                                 { TMBufStream - Creates (or recreates if existed)
                                   and changes mode to stOpen }

  stOpenRead  = $3D00;           { Read access only }
  stOpenWrite = $3D01;           { Write access only }
  stOpen      = $3D02;           { Read and write access }
*)

{  stOk          0      No error
stError       -1     Access error
stInitError   -2     Cannot initialize stream
stReadError   -3     Read beyond end of stream
stWriteError  -4     Cannot expand stream
stGetError    -5     Get of unregistered object type
stPutError    -6     Put of unregistered object type}

{my extension}
  stAppend = $3D03;              { Used in TMBufStream: if not exists,
                                   creates, stOpenWrite, seeks to end }

{ FileMode - file sharing modes }
  {  FileSHARinG !
     When sharing Files concurrently, by means of For example a multitasker or a
     network, it is necessary to use the File sharing as provided by the Dos
     command SHARE, or as provided by a Network shell (In Novell File sharing is
     supported by the network shell on Servers, not locally. Check your network
     documentation For more inFormation).

     File sharing is simple in TP/BP, since the system Variable FileMode defines
     in what mode a certain File is opened in:
  }
Const {see also stream access modes above}
   fmReadOnly  = $00;
   fmWriteOnly = $01;  { Only one of these should be used }
   fmReadWrite = $02;

   fmDenyAll   = $10;  { together With only one of these }
   fmDenyWrite = $20;
   fmDenyRead  = $30;
   fmDenyNone  = $40;

   fmNoInherit = $70;  (* Set For "No inheritance"         *)

  {
     Construction the FileMode Variable is easy, just add the
     appropriate values:

     FileMode:=fmReadOnly+fmDenyNone;
           (Open File For reading only, allow read and Write.)

     FileMode:=fmReadWrite+fmDenyWrite;
           (Open File For both read and Write, deny Write.)

     FileMode:=fmReadWrite+fmDenyAll;
           (Open File For both read and Write, deny all.)

     Say you open the File in "fmReadWrite+fmDenyWrite". This will let you read
     and Write freely in the File, While other processes can freely read the File.
     if another process tries to open the File For writing, that process will get
     the error "Access denied".

     (fmNoInherit is seldom used - it defines if a childprocess spawn from your
     process will be able to use the Filehandle provided by your process.)

     The FileMode Variable is only used when the File is opened;

      ...
     Assign(F,FileName);
     FileMode:=fmReadOnly+fmDenyNone;
     Reset(F);
     FileMode:=<Whatever>     Changing FileMode here does not affect the
                              Files already opened


     By default, FileMode is defined as FileMode:=$02 in TP/BP, this is referred
     to as "Compatibility mode" in the TP/BP docs. Two processes accessing the
     same File With this Filemode results in the critical error "Sharing
     violation".
     ----------------------------------------------------------------------
}

{ipXXXX IOProperties }
const
  ipEOF = 1;{for IOGetProp, set true if GetPos = GetSize}
  ipStatus = 2;
  ipGetTimeout = 3; { how long should IOGet wait for next byte to come,
                      has effect only if BlockingGet = false
                      }
  ipBlockingGet = 4;{ setting true causes to IOGet use blocking Get call,
                      default is non blocking call}
  ipName = 5; {portname or filename}
  ipPos = 6; {get/set(seek) pos}
  ipSize = 7; {get }
  ipInMailBox = 8; { parameter for: IOGetProp(HIO, ipInMailBox, @InBox)
    mailbox where recevied bytes are put by com interrupt task}
  ipOutMailBox = 9;
  ipIONum = 10;      { Number of port, = x for COMx, }
  ipLastGetTime = 11;{ mstime time of byte received before current one }
  ipClearInQue = 12; { IOSetProp .. @truevale - clears input que }
  ipCurGetTime = 13; { arrive mstime of currently received byte }
  ipComFifoTrigLevel = 14; { for S/GetProp(.. @TriggerLevel)}
  ipFlushAlways = 15;{ file will be really flushed upon every Flush}
  ipTruncate = 16;   { IOSetProp(IO, ipTruncate, nil) truncates file }
  ipFlush = 17;      { IOSetProp(IO, ipFlush, nil) will call Stream^.Flush }
  ipBufStream = 18;  { IOGetProp(IO, ipBufStrea, @TBufStream) - get pointer
                       to TV TBufStream object (should not be used ) }

implementation

end.