unit broadcst;
{broadcast command constants}
interface
uses messages;

const
  WM_APPMESSAGE = WM_USER + 1129;
  cmBroadcastUser = 5000;

  cmDisplayClosed = cmBroadcastUser; {send in TDisplay.Done in GDISPLAY.PAS to inform channel}
  cmChannelSelected = cmBroadcastUser + 1;{different channel was selected}
  cmPortAdded = cmBroadcastUser + 2;
  cmChannelStarted = cmBroadcastUser + 3;
  cmChannelStopped = cmBroadcastUser + 4;
  cmChannelPaused = cmBroadcastUser + 5;
  cmChannelResumed = cmBroadcastUser + 6;
  cmMeasure = cmBroadcastUser + 7;

  cmWriteConfig = cmBroadcastUser + 8;
  cmReadConfig = cmBroadcastUser + 9;

  cmUpdateStatusWindow = cmBroadcastUser + 10;
  cmUpdateStatus = cmBroadcastUser + 11;
  cmReportError = cmBroadcastUser + 12;
  cmWaitBoxUpdated = cmBroadcastUser + 13;{called from WaitBoxUpdate1 proc to inform App,
    that it should call Idle}
  cmAutoSaveTime = cmBroadcastUser + 14;
  cmReportInfo = cmBroadcastUser + 15;
  cmCallIdle = cmBroadcastUser + 16;{similar to WaitBoxUpdated but no open waitbox
    necessary to call App.Idle}

{ghlink}
  cmCommWindowIncCount = cmBroadcastUser + 50;
  cmCommWindowWriteCount = cmBroadcastUser + 51;
  cmCommWindowMsg  = cmBroadcastUser + 52;
  cmCommWindowError = cmBroadcastUser + 53;
  cmComPortSelected = cmBroadcastUser + 54;{when com1,2..4 was selected in comdial}
  cmUpdateClock = cmBroadcastUser + 55;{request for updating clock}

  cmTextSelected = cmBroadcastUser + 56;{in windows, send if text in TMEdit selected}
{ghmenu broadcast messages:}
  cmGHMENUBroadcast = cmBroadcastUser + 100;

  cmModuleChanged = cmGHMenuBroadcast;
  cmDayChanged = cmGHMenuBroadcast + 1;
  cmUpRowLedChanged = cmDayChanged;

  cmReaderCardIDSet = cmGHMenuBroadcast + 2;
  cmEditingCustomerReq = cmGHMenuBroadcast + 3;
  cmEditingCardRecordReq = cmEditingCustomerReq;

  cmTodayChanged = cmGHMenuBroadcast + 4;
  cmCardRegistered = cmGHMenuBroadcast + 5;
  cmEditPaymentsDialog = cmGHMenuBroadcast + 6;
  cmEditingPaymentsDialog = cmGHMenuBroadcast + 7;
  cmEditingOrderMeals = cmGHMenuBroadcast + 8;
  cmSetShouldSetID = cmGHMenuBroadcast + 9;
  cmWorkerChanged = cmGHMenuBroadcast + 10;

  cmMakeSubViewMenuItems = cmGHMenuBroadcast + 11;
{meal ordering}
  cmMonthDaySet = cmGHMenuBroadCast + 20;
  cmMealSet = cmGHMenuBroadCast + 21;
  cmDownRowLedChanged = cmMealSet;

  cmWriteContent = cmGHMenuBroadCast + 22;{for testpack - write objects content
    as response to this command (not broadcast)}
{dbfedit cm constants:}
  cmDBFEdit = cmGHMenuBroadcast + 100;

  cmDBFLineUp =  cmDBFEdit;
  cmDBFLineDown = cmDBFEdit + 1;
  cmDBFPageUp = cmDBFEdit + 2;
  cmDBFPageDown = cmDBFEdit + 3;
  cmAdjustLines = cmDBFEdit + 4;
  cmGetInputLine = cmDBFEdit + 5;
  cmDBFRecordChanged = cmDBFEdit + 6;{sent after SaveRec (if was any change)}
  cmGetFieldInputLine = cmDBFEdit + 7;
  cmClosingBrowseWindow = cmDBFEdit + 8;
  cmDBFIndexRecordLoaded = cmDBFEdit + 9;{sent after GetIndexRecord}
  cmOpenFieldMenu = cmDBFEdit + 10;
  cmOpenDBFMenu = cmDBFEdit + 11;

{testing commands}
  cmReplayStart = cmGHMenuBroadcast + 200;
  cmReplayPause = cmGHMenuBroadcast + 201;
  cmReplayResume = cmGHMenuBroadcast + 202;
  cmReplayStop = cmGHMenuBroadcast + 203;

  cmTestingMode = cmGHMenuBroadcast + 210;
{  cmTestingModeOff = cmGHMenuBroadcast + 211;}
  cmMagic = cmGHMenuBroadcast + 212;
  cmTestingLeds = cmGHMenuBroadcast + 213;
  cmSystemDate = cmGHMenuBroadcast + 214;
  cmCardsTableChanged = cmGHMenuBroadcast + 215;
  cmCardsTableContentChanged = cmGHMenuBroadcast + 216;{by modules actions}
  cmTouchRAMTransferEnded = cmGHMenuBroadcast + 217;{transfer from or to touch ram ended, application
    should call touchramtable.Process.. method}
  cmLockIdle = cmGHMenuBroadcast + 218;{disable calling idle proc}
  cmUnlockIdle = cmGHMenuBroadcast + 219;
  cmLockComPorts = cmGHMenuBroadcast + 220;{in sumenu, call lockidle and unlockidle}
  cmOpenSyslogWindow = cmGHMenuBroadcast + 221;
  cmCloseLogFiles = cmGHMEnuBroadcast + 222;
  cmAbortProgram = cmGHMEnuBroadcast + 223;
  cmOfflineModuleRelatedDataChanged = cmGHMenuBroadcast + 224;
  cmRemovePresenceDuplicates = cmGHMenuBroadcast + 225;
  cmHandleTouchRAMFile = cmGHMenuBroadcast + 226;
  {i.e. row or column of led assigned to user or the panel number changed}
  cmModeSaved = cmGHMenuBroadcast + 227;{sent when GHLINK mode was file just saved to file}

  cmX5File = 6000;{100 commands up to 6100 reserved for x5pkt}

  cmQueryBase = 6100;
  cmQueryTextSelected = cmQueryBase;
  cmQueryFileName = cmQueryBase + 1;

  cmCut = cmQueryBase + 2;
  cmCopy = cmQueryBase + 3;
  cmPaste = cmQueryBase + 4;
  cmQueryIsEditWindow = cmQueryBase + 5;
  cmQueryIsModified = cmQueryBase + 6;


  cmSFXIndexWindowClosing = cmQueryBase + 7;
    {sent by SFXIndexWindow from its Close method to its edit
     window; it should close itself as response}
  cmSFXEditWindowInvalidateRecord = cmQueryBase + 8;
  cmSFXEditUpdateCaption = cmQueryBase + 9;
  cmSFXEditSetText = cmQueryBase + 10;
  cmSFXEditQuerySaveRequired = cmQueryBase + 11;
  cmQueryIsIndexWindow  = cmQueryBase + 12;

  cmCloseRecord = cmQueryBase + 13;
implementation
end.