{ Simple dialog for selecting file from given directory showing
  ONLY files (no directories) matching given mask }
unit FileDlg;{v0.61}
{
  (C) 2000 - 2002 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, LsFileExplorer26, WinUtl;

type
  TFileDialog = class(TForm)
    OldFileListView: TListView;
    ViewStyleComboBox: TComboBox;
    FileListView: TLsFileListView26;
    BottomPanel: TPanel;
    OKButton: TButton;
    CancelButton: TButton;
    MoreButton: TButton;
    OpenDialog: TOpenDialog;
    procedure ViewStyleComboBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FileListViewDblClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure MoreButtonClick(Sender: TObject);
  private
    { Private declarations }
    FClosing: boolean;
    procedure SetInitialDir(ADir: string);
    function GetInitialDir: string;
    procedure SetMask(AMask: string);
    function GetMask: string;
    function GetFileName: string;
    procedure SetFileName(AFileName: string);
    procedure FileSelected;
    property Closing: boolean read FClosing write FClosing;
  public
    { Public declarations }
    property InitialDir: string read GetInitialDir write SetInitialDir;
    property Mask: string read GetMask write SetMask;
    property FileName: string read GetFileName write SetFileName;
  end;

var
  FileDialog: TFileDialog;

{ Shows FileDialog filled with with files from AInitialDir matching
  AMask, eventually with a preselected file (with FileName = AFileName).
  Returns true if some file selected, the name set to AFileName. }
function FileDialogExecute(const AInitialDir: string; const AMask: string;
  var AFileName: TFileName): boolean;

implementation

{$R *.DFM}

procedure TFileDialog.ViewStyleComboBoxChange(Sender: TObject);
begin
  FileListView.ViewStyle := TViewStyle(ViewStyleComboBox.ItemIndex);
end;

procedure TFileDialog.FormCreate(Sender: TObject);
begin
  ViewStyleComboBox.ItemIndex := 3;
  FileListView.ShowFolders := false;
  FileListView.DblClickEnabled := false;
end;

procedure TFileDialog.SetInitialDir(ADir: string);
begin
  if ADir = '' then
    GetDir(0, ADir)
  else
    ADir := DelSlash(ADir);
  FileListView.Directory := ADir;
end;

function TFileDialog.GetInitialDir: string;
begin
  Result := FileListView.Directory;
end;

procedure TFileDialog.SetMask(AMask: string);
begin
  FileListView.Mask := AMask;
end;

function TFileDialog.GetMask: string;
begin
  Result := FileListView.Mask;
end;

function TFileDialog.GetFileName: string;
begin
  Result := FileListView.SelectedItem;
end;

procedure TFileDialog.SetFileName(AFileName: string);
var s: string;
begin
  if not Closing then begin
    s := ExtractFileDir(AFileName);
    if s <> InitialDir then
      InitialDir := s;
    if pos(UpperCase(ExtractFileExt(AFileName)), UpperCase(Mask)) = 0 then begin
      Mask := Mask + ';' + '*' + ExtractFileExt(AFileName);
    end;
  end;
  FileListView.SelectedItem := AFileName;
end;


function FileDialogExecute(const AInitialDir: string; const AMask: string;
  var AFileName: TFileName): boolean;
var
  f: TFileDialog;
begin
  f := TFileDialog.Create(Application);
  try
    f.InitialDir := AInitialDir;
    f.Mask := AMask;
    if f.ShowModal = mrOK then begin
      AFileName := f.FileName;
      Result := true;
    end else begin
      Result := false;
    end;
  finally
    f.Free;
  end;
end;

procedure TFileDialog.FileListViewDblClick(Sender: TObject);
begin
  FileSelected;
end;

procedure TFileDialog.OKButtonClick(Sender: TObject);
begin
  FileSelected;
end;

procedure TFileDialog.FileSelected;
begin
  if FileName <> '' then
    ModalResult := mrOK;
end;

procedure TFileDialog.MoreButtonClick(Sender: TObject);
var
  s: TStringList;
  i: integer;
begin
  s := TStringList.Create;
  try
    OpenDialog.InitialDir := InitialDir;
    ParseLine([';'], Mask, s);
    OpenDialog.Filter := '';
    for i := 0 to s.Count - 1 do begin
      OpenDialog.Filter := {v0.62 BUGFIX}OpenDialog.Filter + {/v0.62}
        s[i] + '|' + s[i] + '|';
    end;
    if OpenDialog.Execute then begin
      Closing := true;
      FileName := OpenDialog.FileName;
      FileSelected;
    end;
  finally
    s.Free;
  end;
end;

end.

