program chkulf;
{$APPTYPE CONSOLE}
uses
  SysUtils,
  CmdLine,
  ChkULFu in 'ChkULFu.pas';

const
  ChkOptionCount = 1;

  ChkOptions: array[1..ChkOptionCount] of TOptionRec = (
    (OptionName:'f'; OptionDesc:nil; Flag:0;Present:false; Option: otBool; OnOff: false)
  );

var
  i: integer;
  s, inf: string;
begin
  Assign(output,'');
  rewrite(output);
  try
  if paramcount = 0 then begin
    Writeln('Usage: chkulf [-f] FileName');
    Writeln('Checks the Chromulan data file FileName[.ULF] for errors (X axis time values).');
    writeln('Reports them and if -f option specified, fixes them');
  end else begin
    if ProcessCommandLine(@ChkOptions, ChkOptionCount) then begin
      inf := '';
      for i := 1 to paramcount do begin
        s := paramstr(i);
        if (s <> '') and (s[1] <> '-') then begin
          if inf = '' then
            inf := s
        end;
      end;

      if inf = '' then begin
        writeln('No input file specified.');
      end else begin
        try
          ChkDataFile(inf, ChkOptions[1].OnOff);
          writeln('ChkULF succeeded.');
        except
          on E:Exception do
            writeln('ChkULF failed. ' + E.Message);
        end;
      end;
    end else begin
      writeln('Ivalid command line parameters.');
    end;
    writeln('Press Enter to finish.');
    readln;
  end;
  finally
    close(output);
  end;
end.
