unit fm_BaseCount1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  Tfm_BaseCount = class(TForm)
    Label1: TLabel;
    tx_Base: TEdit;
    Label2: TLabel;
    tx_Count: TEdit;
    bt_OK: TButton;
    bt_Cancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure tx_BaseChange(Sender: TObject);
    procedure bt_OKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
    LastBase : integer;
    LastCount: integer;
  end;

var
  fm_BaseCount: Tfm_BaseCount;

//------------------------------------------------------
implementation
//------------------------------------------------------
uses gwutil_1;

{$R *.DFM}

Const
  BaseMax = $FFFF;
  BaseMin = 0;
  CountMax = $100;
  CountMin = 0;

//------------------------------------------------------
procedure Tfm_BaseCount.FormCreate(Sender: TObject);
//------------------------------------------------------
begin
  LastBase  := 0;
  LastCount := 0;
end;

//------------------------------------------------------
procedure Tfm_BaseCount.tx_BaseChange(Sender: TObject);
//------------------------------------------------------
begin

end;

//------------------------------------------------------
procedure Tfm_BaseCount.bt_OKClick(Sender: TObject);
//------------------------------------------------------
begin
end;

//------------------------------------------------------
procedure Tfm_BaseCount.FormShow(Sender: TObject);
//------------------------------------------------------
begin
  tx_Base.Text  := IntToHex(LastBase ,4);
  tx_Count.Text := IntToHex(LastCount,4);
end;

//------------------------------------------------------
procedure Tfm_BaseCount.FormClose(Sender: TObject; var Action: TCloseAction);
//------------------------------------------------------
Var
  BaseTemp, CountTemp: integer;
Label Err, Good, the_end;
begin
  BaseTemp := HexToIntDef(tx_Base.Text, -1);
  If (BaseTemp > BaseMax) or (BaseTemp < BaseMin) then
  Begin
    tx_Base.SetFocus;
    goto Err;
  end;

  CountTemp := HexToIntDef(tx_Count.Text, -1);
  If (CountTemp > CountMax) or (CountTemp < CountMin) then
  Begin
    tx_Count.SetFocus;
    goto Err;
  end;

  goto Good;
Err:
  Action := caNone;
  goto the_end;
Good:
  LastBase  := BaseTemp;
  LastCount := CountTemp;
the_end:
end;

end.
