program h2pas;
{$APPTYPE CONSOLE}
{converts C constants file to pascal constants file }
uses
  SysUtils, WinUtl;

procedure FSplit(AFileName:string; var ADir:string; var AName:string; var AExt:string);
var p:integer;
begin
  p := length(AFileName);
  ADir := '';
  AName := '';
  AExt := '';
  while (p > 0) and (AFileName[p] <> '.') do dec(p);
  if p > 0 then begin
    AExt := copy(AFileName, p, 255);
    AFileName := copy(AFileName, 1, p -1); dec(p);
  end;
  while (p > 0) and (AFileName[p] <> '\') and (AFileName[p] <> ':') do
    dec(p);
  if p > 0 then begin
    ADir := copy(AFileName, 1, p);
    AName := copy(AFileName, p + 1, 255);
  end else begin
    AName := AFileName;
  end;
end;
  

procedure Convert(InFile, OutFile: string);
var
  s,valu:string;
  p:byte;
  fin,fout:text;
  d:string;
  n:string;
  e:string;
  def,
  name,
  rest: string;
  isincomment: boolean;
begin
  InFile := ChangeFileExt(InFile, '.H');
  if OutFile = '' then
    OutFile := ChangeFileExt(InFile, '.PAS')
  else
    OutFile := ChangeFileExt(InFile, '.PAS');
  AssignFile(fin, InFile);
  reset(fin);
  assign(fout, OutFile);
  rewrite(fout);
{  d := ExtractFilePath(OutFile);
  n := ExtractFileName(OutFile);}
  FSplit(OutFile, d, n, e);
  writeln(fout,'unit ' + n + ';');
  writeln(fout,'interface');
  writeln(fout,'const');

{  writeln(}
  isincomment := false;
  while not eof(fin) do begin
    readln(fin, s);

    s := trim(s);
    p := pos('#define', s);
    {scanthem\twain.h
/****************************************************************************
 * Generic Constants                                                        *
 ****************************************************************************/

#define TWON_PROTOCOLMINOR   6 /* Changed for Version 1.6            */
#define TWON_PROTOCOLMAJOR   1

#define TWON_ARRAY           3 /* indicates TW_ARRAY container       */
}
    if p > 0 then begin
      { line starts with #define }
      ExtractWord([' ', #9], def, s);
      s := trim(s);
      ExtractWord([' ', #9], name, s);
      s := trim(s);
      ExtractWord([' ', #9,'/'], valu, s);
      if (def <> '') and (name <> '') and (valu <> '') then
      begin
        s := '  ' + name + ' = ' + valu + '; ' + s;
      end else begin
        s := '{' + s + '}';
      end;
    end else begin
      { line does not start with #, comment it out if not in comment yet }
      if (not IsInComment) and (s <> '') then
        s := '{' + s + '}';
    end;

    if (s <> '') and (s[1] <> '{') then begin
      p := pos('/*', s);
      if p > 0 then begin
        delete(s, p, 2);
        insert('{*', s, p);
        isincomment := true;
      end;
      p := pos('*/', s);
      if p > 0 then begin
        delete(s, p, 2);
        insert('*}', s, p);
        isincomment := false;
      end;
    end;
    {v1.01}
    writeln(fout, s);
    {/v1.01}
  end;
  writeln(fout,'implementation');
  writeln(fout,'end.');
  close(fin);
  close(fout);
end;

begin
  if paramcount = 0 then begin
    writeln('Usage: H2PAS file1[.H] [file2[.PAS]]');
    writeln(' Converts C constants file to PAS constants file.');
  end else begin
    convert(paramstr(1), paramstr(2));
  end;
end.
