unit UlanType;{ Constants, types for CHROMuLAN program
  (for constants for uLan driver see ULDrvTyp) }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

{fnXXXX not defined, field names specified for each TULxType section separately}
interface
uses Windows {v0.62}, ULRecTyp{/v0.62};
const
  uLanVersion = '0.62';
    { see \ulan\history.txt, change \ulan\readme.txt, chromulan.iss (2x),
      chromutils.iss (2x) }
    { 0.04 - with Delphi4, Tools|ComWindow - inspecting port }
  RcvBufSize = 1024;

{v0.22 moved to ulrectyp}{/v0.22
  SortStrPrecision = 7;}
    { Used as parameter for FloatToStrF function in GetSortStr methods }
{v0.22 moved to ulrectyp}{/v0.22
  SortStrDigits = 0;}
    { Used as parameter for FloatToStrF function in GetSortStr methods }
  NoIndexValue = MaxLongint;
  MaxSingle = 3.4e38;
  MinSingle = -MaxSingle; {single}

  MaxXValue = MaxSingle;
  MaxYValue = MaxSingle;
  MinXValue = MinSingle;
  MinYValue = MinSingle;

  MinAcqXValue = 0;
  MaxAcqXValue = MaxSingle;
  MaxAcqYValue = {v0.13}MaxSingle / 4;{/v0.13 2;}
  MinAcqYValue = {v0.13}MinSingle / 4;{/v0.13 -2;}
  {v0.13}
  DefMaxAcqYValue = 2;
  DefMinAcqYValue = -2;
  DefMinUsrYValue = -0.1;
  DefMaxUsrXValue = 20;
  {/v0.13}

  {v0.22 moved to ULRecTyp}
  {/v0.22 TMPExt = '.$$$';}
    { Extension for RAW data files, that were not finished yet
      (acquisition is running) }
  DATExt = '.DAT';
    { Old (raw) data format, just array of record X:longint;Y:single end }
  TXTExt = '.TXT';
    { Extension for ASCII files containing just RAW DATA for export/import }

  {v0.22 moved to ULRecTyp}
  {/v0.22 ASCExt = '.ASC';}
    { Extension for ASCII file containing all info normally stored in ULF files
      but in ASCII. Used for conversions if structures of data changed
      substantially (then all .ULF files should be exported to .ASC by old
      version of the program and imported by the new version). }
  ULDExt = '.ULD';
    { File with list of devices }
  GExt = '.G'; { AAA mikro data file for line G }
  BExt = '.B'; { AAA mikro data file for line B }
  {v0.50}
  HeaExt = '.HEA'; { AAA mikro header file }
  {/v0.50}
  
  {v0.18}
  TomExt = '.TOM';
  {/v0.18}

  ULTExt = '.ULT';
    { Analysis template file }

  {v0.41 moved to ulrectyp}{/v0.41
type
  TOpenMode = (omCreate, omRead, omReadOnly, omCreateTemplate);}
    { Modes for opening analysis:
      omCreate - data will be acquired
      omRead - acquired data will be viewed/worked with (can be modified and saved)
      omReadOnly - acquired data will be viewed, any changes will not be possible
                   to save
      omCreateTemplate - only used for creating template files }

type
  TRunningState = (rsStopped, rsReadyToRun, rsRunning{v0.18},rsSuspended{/v0.18});

  TColumnName = string[60];
    { name/description of the column used }
  TMobilePhase = string[60];
    { description of the mobile phase used }
  TDetection = string[60];
    { description of the detector/detection method used }

  TFlowRate = single;
    { flow rate in mL/min }
  TUserFlowRate = single;
    { flow rate in flow rate units }
  TFlowRateUnit = (fuML_MIN, fuUL_MIN);
    { flow rate units mL/min, uL/min (=microliter/min) }

  {v0.23}
  TTemperature = single;
  {/v0.23
  TTemperature = longint;}
    { Temperature in deg. of Celsius }
  TUserTemperature = longint;
    { Temperature in temperature units. }
  TTemperatureUnit = (tuCelsius, tuFahrenheit, tuKelvin);
  TCompoundAmount = single;
    { When using calibration, here is calculated amount in moles of
      the compound (in ULPRType) }
  TUsrPeakCoef = single;
    { in ULPRType }

  {X}
  TXValue = single;
    { Type of generic X value in X->Y dependencies used in Ulan. }
  TAcqTime = TXValue;
    { Time values used for description of data acquisition.
      Ulan always uses seconds as units for variables of the type TAcqTime. }
  TUserAcqTime = TXValue;
    { Time in current AcqTimeUnits. }
  TAcqTimeUnit = (tuMin, tu0_1Min, tu0_01Min, tuSec, tuMilisec);
    { What units can be used for TUsrAcqTime values. tu0_1Min means
      the unit s 1/10 of minute, tu0_01Min means 1/100 of minute.
      Ulan uses tuSec by default. }

  TXValueType = (xtNone, xtByte, xtWord, xtDWord,
    xtInt8, xtInt16, xtInt32, xtSingle{v0.18}, xtMSFloat4{/v0.18});
    { What is the binary format of X values (for import/export).
      If xtNone, then y values are scanned in constant
      time intervals. Ulan uses xtSingle - see TAcqTime. }
  {/X}

  {Y}
  TYValueType = (ytNone, ytByte, ytWord, ytDWord,
    ytInt8, ytInt16, ytInt32, ytSingle{v0.18}, ytMSFloat4{/v0.18});
    { What is the format of Y values (for import/export). (ytNone not used,
      of course, just for consistency with TXValueType.)
      Ulan uses ytSingle - see TYValue. }
  TYValue = single;
    { Type of variables used to store absorbance or any other Y (X dependent)
      value acquired in Ulan system. The number is always in units yuAU. }
  TUsrYValue = TYValue;
    { Y values in current Y units (user defined). }
  TYUnit = (yuAU);
    { What units can be used for TUsrYValue. }
  {/Y}

  TContent = single;
    { percentage content e.g. of the solvent in mobile phase }
  TDilution = single;
    { Number used to multiply the acquired values to
      get wanted values. }
  TUserID = longint;
    { Unique ID of user. }
  TUserName = string[20];
    { Short - login name of the user. }
  TRealUserName = string[60];
    { Real world user name }
  TPassword = string[20];
    { Password }
  TSampleName = string[20];
    { Short name of the sample. }
  TSampleDesc = string[60];
    { Longer description of the sample. }
  TSampleNote = string[60];
    { eventual note regarding the sample }
  TSampleAmount = single;
  TInjectionVolume = single;
  TImpExpDefName = string[20];
    { name of the data import/export definition record
      (to every definition should be assigned unique name) }
  TDelimiterString = string[20];
    { For defininig word or line delimers in ULEType . }
  TBaseLineName = string[20];
  TGradientName = string[20];

{ULLType RAW DATA FILTRATION parameters}
type
  TFilterType = (ftNone, ftAvg, ftFilter1);
    { ftNone    - showing umodified signal
      ftAvg     - averaging every ulanglob .AvgPointCount points
      ftFilter1 - using last point to calculate this point using
                  ulanglob.Filter1 coeficient }
  TFilterCoef = single;
    { Coeficient used in ftFilter1 type fiter method }
  TFilterName = string[20];    
const
  MaxAvgPointCount = 100;
    { what is the maximal allowed count of points that can be averaged }
type
  TFilterPars = record
    FilterType: TFilterType;
    AvgPointCount: longint;
    Filter1: TFilterCoef;
  end;
  PFilterPars = ^TFilterPars;

{/ULLType RAW DATA FILTRATION parameters}

type
  TRcvProperty = integer;

{rpXXXX scaninputinfo receive obect properties (ul_lcabs),
  params for RcvSetProp, RcvGetProp }
const
  rpZeroTime = 1;
{/rpXXXX}

{soXXXX spectrum objects:}
const
  soData = 0;
    { chromatogram }
  soAxis = 1;
    { X,Y axes with descriptions }
  soBaseLine = 2;
    { baseline sections }
  soPeaks = 3;
    { peak descriptions, limits }
  soReport = 4;
    { window summary report with info about peaks }
  soXY = 5;
    { window that shows coordinates of mouse pointer }
  soHeader = 6;
    { Text description of the sample }

  SpectrumObjectCount = 7;
{/soXXXX}

{trXXXX ToRedraw flags, corresponds to soXXXX}
const
  trData = 1;
  trAxis = 2;
  trBaseLine = 4;
  trPeaks = 8;
  trReport = $10;
  trHeader = $20;

  trAll = $FFFF;
{/trXXXX}

{pdXXXX peakdefinemode/baselinedefinemode (mouse dragging)}
const
  pdNone = 0;
  pdReady = 1;{waiting for mouse down}
  pdCreate = 2;{in mousedown set to create new peak}
  pdMove = 3;{ in mouse down set to move existing peak}
  pdSizeLeft = 4;{ in mouse down set to size peak's left edge }
  pdSizeRight = 5;{ in mouse down set to size peak's right edge }
  pdInsertPoint = 6; { insert baseline point }
{/pdXXXX}

type
  TDefineMode = (
{dmXXXX Define modes for spectrum form}
  dmNone,
  dmBaseLine,
    { Defining new baseline interval }
  dmMargins,
  dmPeaks
    { Defining new peak }
  {v0.09}
  ,dmShowPos
    { cross over chromatogram, showing coordinates of the intersection }
  ,dmOverlay
    { newly opened file is added to active window that is in this mode
      instead of opening new window for it }
  {/v0.09}
  );
{/dmXXXX}
type
  TToRedraw = word;
  TPeakDefineMode = byte;
  TSpectrumObject = integer;

{cmXXXX }
const {cmgh mytype}
  cm0 = 6000;
  cmPeaksDefineAbort = cm0 + 1;
  cmDefineModeSet = cm0 + 2;
    { Posted to app, LParam  = TDefineMode, will call SetDefineMode by
      assigning DefineMode property. See also PermanentDefineModeSet. }
  cmQueryRunning =  cm0 + 3;

  cmPeaksDefineFormClosed = cm0 + 4;{sent from PeaksDefineForm.Close}
  cmReportFormClosed = cm0 + 5;
  cmSpectrumFormClosed = cm0 + 6;

  {cmBaseLineDefineStart = cm0 + 7;
  cmBaseLineDefineStop = cm0 + 8;
  cmMarginsDefineStart = cm0 + 9;
  cmMarginsDefineStop = cm0 + 10;}

{v0.22 moved to mytype}
{/v0.22
  cmClipCut = cm0 + 100;
  cmClipCopy = cm0 + 101;
  cmClipPaste = cm0 + 102;}

  cmSpectrumObjectShow = cm0 + 200;
  {reserved up to cm0 + 200 + 5 = SpectrumObjectCount}
(*v0.22 ULObj related commands moved to ULRecTyp *)
  cmPermamentDefineModeSet = cm0 + 310;
    { as cmDefineModeSet but the define mode will persist even after finishing
      the definition }
(*/v0.22
  cmULObjUserRegister = cm0 + 300;
    { WM_APPMESSAGE sent by (usually visual) object that instantiated
      pointer to ULObject, so that it is included to ULObjects' Users
      list (i.e. it will get messages from the ULObject), lParam = ULObjUser }
  cmULObjUserUnregister = cm0 + 301;
    { see above, removing from ULObjects' Users list }
  cmULObjCanDestroy = cm0 + 302;
    { WM_APPMESSAGE sent by ULObject to all objects in its Users list,
      if some of these objects will set result to 1 (does ULEdFrm and ULBrowu),
      the ULObject will know, that it should not destroy itself yet
      (but ULObj.Free ignores it,  so call ULObj.CanDestroy before calling Free). }
  cmULObjUpdated = cm0 + 303;
    { WM_APPMESSAGE sent by ULObject to all objects in its Users list,
      to inform them, that it has changed some of its property value
      or child counts/values. Beware infinite recursions - see also
      cmULObjAfterEdit, cmULObjAfterBrowseEdit - sent only upon changes
      of values from Edit and  Browse forms.}
  cmULObjDestroyed = cm0 + 304;
    { WM_APPMESSAGE sent by ULObject to all objects in its Users list,
      to inform them, that they should not use pointer to it anymore. }
  cmULObjBeforeEdit = cm0 + 305;
    { WM_APPMESSAGE sent by ULObject to Application.MainForm before an ULEditForm
      is invoked. If Result set to <> 0, editing won't appear. lParam = ULObject }
  cmULEditFormCloseQuery = cm0 + 306;
    { WM_APPMESSAGE sent by ULEditForm to Application.MainForm when it is
      going to be closed with mrOK result (lParam = ULEditForm). If result
      set to <> 0, the from won't be closed }
  cmULObjAfterEdit = cm0 + 307;
    { WM_APPMESSAGE sent by ULObject to Application.MainForm after its ULEditForm
      executed (seea also cmULObjAfterBrowseEdit). lParam = ULObject.
      Better to respond to this message (in other windows then edit) then
      to cmULObjUpdated, that is generated upon EVERY change of ULObj value,
      i.e. even if made inside the receiver window
      (infinite recursion must be watched in such cases)}
  cmULObjEditFormBringToFront = cm0 + 308;
    { WM_APPMESSAGE sent by ULObject to its Users, if there is a editform
      for the objects, it will return 1 and bring itself to front
      (if not, the ULObject will call open new edit form) }
  cmULObjBrowseFormBringToFront = cm0 + 309;
    { WM_APPMESSAGE sent by ULObject to its Users, if there is a browseform
      for the objects, it will return 1 and bring itself to front
      (if not, the ULObject will call open new browse form) }
  cmPermamentDefineModeSet = cm0 + 310;
    { as cmDefineModeSet but the define mode will persist even after finishing
      the definition }
  cmULObjAfterBrowseEdit = cm0 + 311;
    { WM_APPMESSAGE sent by ULObject to Application.MainForm after its
      value in browser row changed (see also cmULObjAfterEdit).
      lParam = ULObject.  Better to respond to this message
      (in other windows then browse) then to cmULObjUpdated, that is generated
      upon EVERY change of ULObj value,  i.e. even if made inside the receiver
      window (infinite recursion must be watched in such cases) }
*)
  {v0.15}
  cmAcquisitionStop = cm0 + 312;
    { WM_APPMESSAGE can be posted/sent to TSpectrumForm to
      call its Stop method }
  {/v0.15}

  {v0.19}
  cmAcquisitionRun = cm0 + 313;
  cmPeaksAutodetected = cm0 + 314;
    { WM_APPMESAGE can be sent to specform after Spect.Autodetect
      method called (not done automatically from the Spect.Autodetect) }
  cmExpPointsAdded = cm0 + 315;
    { SendMessage(wnd, WM_APPMESSAGE, cmExpPointsAddec, longit(TAcqInfo))
      sent to specform window when acqinfo added some points in DoTimer
      call. In the TAcqInfo(lParam).RecentPoints stream are the added points }
  cmAcquisitionResumed = cm0 + 316;
  cmAcquisitionSuspended = cm0 + 317;
  {/v0.19}
  {v0.21}
  cmAcquisitionAborted = cm0 + 318;
  {/v0.21}
  {v0.24}
  cmAcqInfoDestroyed = cm0 + 319;
    { TAcqInfo objects destroing, sent by the AcqInfo, the form should set
      its reference to the AcqInfo to nil }
  {/v0.24}

{/cmXXXX }

type
{ULPRType peak record }
  TAreaSize = single;
  TPeakName = string[40];
  TPeakGroupName = string[12];
  TRatio = single;
{/ULPRType}

  TPointCount = longint;
  TPeakCount = longint;

  PExpPoint = ^TExpPoint;
  TExpPoint = record
    X:TXValue;
    Y:TYValue;
  end;
  TExpPoints = array[0..MaxLongint div 16] of TExpPoint;
  PExpPoints = ^TExpPoints;

  TRecentExpPoint = record
    Index: integer; { if data from more channels are acquired }
    Point: TExpPoint;
  end;

  TExpXLimit = record
    Min,Max:TXValue;
    Size:TXValue;
  end;

  TExpYLimit = record
    Min, Max:TYValue;
    Size:TYValue;
  end;

  TScreenX = integer;
  TScreenY = integer;
  PScreenPoint = ^TScreenPoint;
  TScreenPoint = record
    X:TScreenX;
    Y:TScreenY;
  end;

  TScreenDisp = TRect;
  (*record
    { what part of screen/printer/canvas used to draw the spectrum }
    Left: TScreenX;
    Top: TScreenY;
    Width: TScreenX;
    Height: TScreenY;
    {ZeroIsOnTop: boolean;
      { true if y coordinate has zero on the top of the
        screen; the other values are in this values, i.e. the value
        of Top variable is mostly close to zero if ZeroIsOnTop=true,
        otherwise is close to Height }
  end;
  *)
  PScreenDisp = ^TScreenDisp;

  TScreenPeak = record
    { left margin, maximum, right margin }
    case Integer of
     0: (
          X1: TScreenX;
          Y1: TScreenY;
          X: TScreenX;
          Y: TScreenY;
          X2: TScreenX;
          Y2: TScreenY );
     1: ( P1: TScreenPoint;
          P: TScreenPoint;
          P2: TScreenPoint)
  end;

{opXXXX Out Position flags - result of converting experimental point coordinates
  to screen coordinates }
const
  opRight = 1;
    { point is out of screen on the right }
  opLeft = 2;
    { point is out of screen on the right }
  opAbove = 4;
     { point is out of screen - above the screen }
  opBelow = 8;
     { point is out of screen - below the screen }
{v0.25}
const
   MaxUserX = MaxSingle;
   MinUserX = MinSingle;
   MaxUserY = MaxSingle;
   MinUserY = MinSingle;
{/v0.25}
type
{ULVLType user view limits }{ulatype ulsrtype}
  TUserX = single;
  TUserY = single;
  PUserPoint = ^TUserPoint;
  TUserPoint = record
    X:TUserX;
    Y:TUserY;
  end;

  TUserViewLimit = record
    Min:TUserPoint; {x..time in minutes entered by user, limits of spectrum view}
    Max:TUserPoint; {y..limits of spectrum view in AU units}
    {Size:TUserPoint;{calculated from Min, Max}
  end;
  PUserViewLimit = ^TUserViewLimit;
{/ULVLType }

{ULNType}
type
  TChannelName = shortstring;
const
  fnChannelName = 'ChannelName';
{/ULNType}

{ULDRType}
type
  TDeviceName = string[80];
    { System wide unique name of the device }
  TDeviceDesc = shortstring;
    { Any additional description of the device }
  {v0.14}
  TExtDevDrvName = string;
    { Name of DLL driver file, used for DeviceMode = dmExtDev }
  TDevicePortName = string;
  {/v0.14}

  TDeviceMode =
{dmXXXX device modes, values to be set to IniDevMode ini variable }
  (
    dmUlan,
      { only usable in WIN NT if ulan.drv loaded }
    dmPasive,
      { works in Win95/NT using serial port just for scanning incoming packets }
    dmExtDev
      { works in win95/NT, scans serial port for connected External device -
        AD converter input }
    {v0.41}
    ,dmUnspecified
      { i.e. device mode was not yet specified by user }
    {/v0.41}
  );

{/dmXXXX}
type
  TDeviceType = (
    {v0.41}
    dtUnknown,
    {/v0.41}
    dtDetector,
    dtAutoSampler,
    dtPump,
    dtFractionCollector,
    dtPeakSelector
  );


{v0.14}
const
  fnDeviceName = 'DeviceName';
  fnDeviceMode = 'DeviceMode';
  fnExtDevDrvName = 'ExtDevDrvName';
{/v0.14}

{/ULDRType}
type

  TExpViewLimit = record
    { Limits of spectrum view in exprecord units: }
    Min:TExpPoint;
    Max:TExpPoint;
    { x.. limits in milisecond of spectrum view}
    { y.. up and down limit of the spectrum in AU units }
    Size: TExpPoint; { calculated from Min,Max }
  end;

type
  { points containing also their Data^ index, used for working up of spectrum}
  TIndexPoint = record
    Point:TExpPoint;
    Index:TPointCount;
  end;
  TIndexLimit = record
    Min, Max:TIndexPoint;
  end;
  PSpectrumOpt = ^TSpectrumOpt;
  TSpectrumOpt = record
    MaxPointCount:TPointCount;
      { maximally that number of points will be taken to account 0 for all }
    MaxPeakCount:TPeakCount;
      { max this number of points will be stored, 0 for all }
    Trashold: TYValue;
      { only peaks with y above that value will be stored }
    BaseLine: TYValue;
      { only peaks within specified values will be considered to be separate
        peeks, value 0 means no limits: }
    PeakHeight: TExpYLimit;
    PeakArea: TExpYLimit;
    PeakWidth: TExpXLimit;
    PeakStartLevel: TYValue;
    PeakEndLevel: TYValue;
      { For y > baseline + PeakStartLevel the peak starts. }
      { For y < baseline + PeakEndLevel the peak ends. }
    ViewLimit: TExpViewLimit;
      { what portion of the spectrum to show }
    Limit: TExpViewLimit;
      { min and max values of the spectrum allowed to be shown,
        i.e. = maximal ViewLimit allowed }
    {UserLimit: TUserViewLimit;}
      { in user units the same part as ViewLimit }
    PointCount: TPointCount; {max size of spectrum in TPointCount units
                             = number of spectrum points collected }
    Extreme: TExpViewLimit; {experimentally found extreme values, peaks;
                              won't be set more then defined Limit}
    XAxisName: PChar;
    YAxisName: PChar;
  end;


(* changed to ULPRType  ulobju
  PPeak = ^TPeak;
  TPeak = record
    P1,P2: TIndexPoint;
    X: TXValue;
      { Position of the peak (X of its maximum). }
    Width: TXValue;
      { Width of the peak in the middle of its height. }
    Height: TYValue;
      { Max height of the peak. }
    AreaSize: TAreaSize;
      { Area of the peak. }
    Ratio: TRatio;
      { Ratio AreaSize/(AreaSize of all peaks). }
  end;
*)
const
  MousePointArea = 2;
    { how many points around the target point are considered to be a match}
  MaxDataCountInForm = 8;
    { What is the maximal allowed number of overlayed chromatograms }
  PointsPeakStickLen = 8;
    { Length of the Peak limit sign (stick with arrow) above the exp.data line
     (and below the baseline) - in screen points }
  MMPeakStickLen = 3;
    { The above length but for printing, in milimeters }
  PointsPeakArrowLen = 8;
    { Length of the arrow }
  MMPeakArrowLen = 3;
    { The above length but for printing, in milimeters }
  PointsBaseLineCircleRadius = 4;
    { Circle radius for base line edge margins }
  MMBaseLineCircleRadius = 0.5;
    { The above diameter in milimeters for printing }

(*v0.22 moved to ulrectyp
{umXXXX}
  { Global variable UserMode specifies how the program
    should behave }
type
  TUserMode = (
    umSysop,
      { ULObj browsers allow access to all properties,
        user dialogs replaced by ULEdit dialogs with
        all properties enabled }
    umUser
  );
{/umXXXX}
*)
const
  SpecSection = '[Spectra]';
  DevSection = '[Devices]';
const
  RectInclusive = 1;
    { when using TRect to specify drawing rectangle, does to Bottom and
      Right belong to it? }
{rtXXXX report types printable from SpectrumForm window }
type
  TReportType = (
    rtWindow,
    rtReport
  );
{/rtXXXX}

{crXXXX cursors (loaded in main.MainForm.LoadCursors)}
const
  crThinCross = 1;
  crZoomIn = 2;
  crThinCrossUp = 3;

{/crXXXX}
{v0.09}
const
  MaxDataListColorCount = 5;
{/v0.09}
{v0.11}
type
  PExtDevDrv = pointer;
{v0.22}
  TExtDevResult = integer;
  TExtDevProperty = integer;
{/v0.22}

{edrXXXX External Device Result codes}
const
  edrOK = 0;
  edrBufferEmpty = -1;
  edrBufferFull = -2;
  edrInvalidParam = -3;
  edrNotRunning = -4;
  {v0.22}
  edrInvalidInput = -5;
  edrInvalidExtDevAction = -6;
  edrInvalidSetStrProp = -7;
  edrInvalidGetStrProp = -8;
  edrUnsupportedDeviceType = -9;
  {/v0.22}
{/edrXXXX}

{v0.22}
{epXXXX Ext device Properties}
const
  ep0 = 8000;
  epDeviceTypeName = ep0 + 1;
  epQuantityName = ep0 + 2;
  epUnitName = ep0 + 3;
{/epXXXX}
{/v0.22}

type
  TResponse = single;
  TFactor = single;

  TSpectrumResult = integer;
{srXXXX Spectrum Results}
const
  srPeakResponseZero = 1;
  srPeakAmountZero = 2;
  srPeakAreaZero = 3;
  srNoInternalStandardSpecified = 4;
  srCalibrationFileNotSpecified = 5;
  srTemplateNotFound = 6;
  {v0.55}
  srCalibrationFileNotFound = 7;
  {/v0.55}
{/srXXXX}

type
  TDataMathOperation = integer;
{moXXXX data Math Operations}
const
  moNoneOp = 0;
  moMultiplyX = 1;
  moMultiplyY = 2;
  moAddX = 3;
  moAddY = 4;
  {v0.21}
  moDilute = 5;
  {/v0.21}
{/moXXXX}
{/v0.11}

{pvXXXX}
{v0.14}
const
  pvPasiveDefaultDevice = 'Pasive Default Device';
    { Name of the default device for Pasive mode communication }

  pvPasiveDefaultChannel = 'Pasive Default Channel';
  pvUlanDefaultChannel = 'uLan Default Channel';

  pvPasiveDefaultTemplate = 'PasiveDefaultTemplate.ULT';
  pvUlanDefaultTemplate = 'uLanDefaultTemplate.ULT';
  {v0.41}
  {v0.50}
  pvAAAChannel = 'AAA-400 Channel';
  {/v0.50
  pvUlanDefaultSeq = 'UlanDefaultSeq.ULT';
  pvPasiveDefaultSeq = 'PasiveDefaultSeq.ULT';
  pvEmptySeq = 'EmptySeq.ULT';
  pvFromFileSeq = 'FromFileSeq.ULT';}
  {/v0.41}

{/v0.14}
{v0.18}
  pvEmptyTemplate = 'Empty.ULT';
  pvFromFileTemplate = 'FromFile.ULT';

  pvEmptyChannel = 'Empty';
  pvFromFileChannel = 'From File';
{/v0.18}
{v0.18}
{/pvXXXX}

type
  TExtName = string[4];
const
  fnDefName = 'DefName';
    { name of the TULEObj field holding name of exp/imp definition }
  fnExtName = 'ExtName';
    { name of the TULEObj field holding name of default file extension }
{/v0.18}

{v0.21}
type
  TExtDevAction = longint;
{eaXXXX ExtDevIntu DoAction parameters }
const
  eaPortBeforeOpen = 1;
    { called before ComPort Open (extdev can modify comport parameters
      in Chromulani.Ini file), PShortString(Info)^ = PortName }
{/eaXXXX}
const
  DefDataWaitTimeout = 5;
    { wait for 5 seconds before reporting no data from acquisition }
{/v0.21}

{v0.22}
type
  TULPrgsName = string[40]; 
  TULPrgName = string[40];
  TULPrgTime = single;
  TULPrgState = (
    psStopped,
    psPreparingToRun,
    psReadyToRun,
    psRunning,
    psSuspended
  );
  TULPrgExpsPoolName = string[40];
  TULPrgExpsName = string[40];
  TULPrgExpName = string[40];

  TULPrgExpResType = (
    rtBool,
    rtInteger,
    rtFloat,
    rtString
  );{ of what type is the result of this combined expression }

  TULCmpOper = (
    coNone,
    coLT,  { less then}
    coLET, { less or equal to }
    coET,  { equal to }
    coGET, { greater or equal to  }
    coGT,  { greater then }
    coNE   { not equal }
  );

  TULMathOper = (
    moNone,
    moNOT,
    moAND,
    moOR,
    moMinus,
    moPlus,
    moMultiply,
    moDivide
  );

  TULPrgExpSrcType = (
    stPrgExps,
    stDeviceProp,
    stConstant
  );

  TULPrgStepsName = string[40];
  TULPrgStepName = string[40];
  TULPrgActionsPoolName = string[40];
  TULPrgActionsName = string[40];
  TULPrgActionName = string[40];

  TULPrgConditionsPoolName = string[40];
  TULPrgConditionsName = string[40];
  TULPrgConditionName = string[40];

{/v0.22}
{v0.23}
  TDeviation = single;
  TPressure = single;
{/v0.23}
{v0.24}

{/v0.24}

{v0.30}
const
  CalibrationFileFilter = 'Data file (' + '*.ULF)|*.ULF';

type
  TResultTableValue = (tvAmount, tvArea, tvRatio, tvResponse, tvX, tvWidth, tvHeight);

const
  ResultTableValueName : array[TResultTableValue] of string
    = ('Amount', 'AreaSize', 'Ratio', 'Response', 'X', 'Width', 'Height');
{/v0.30}

{v0.49}
type
  TScriptName = string;
  TScriptParam = string;
  {v0.51}
  TInDeviceLineType = string;
  {/v0.51}
  {v0.50}
  TSeqCommand = (scNone, scStartEquil, scAcqStart, scAcqStop);
  TPrgEventCondition = string;
  TPrgEvent = (peNone, peBeforeStart, peAfterStop, peTimer, peCondition, peError, peNamed);
  TPrgLineKind = (
    plkTime,   { program line to be executed at specified time }
    plkEvent,  { program line to be executed if specified PrgEvent occurs }
    plkDevice  { program line that will be sent to device and executed there
                 at specified time (same structure as plkTime lines) }
  );
  {/v0.50}

  TPrgLineName = string;
  TPrgLineNote = string;
  TPrgLineState = (plsNone, plsWaiting, plsRunning, plsDone, plsFailed, plsSkipped);
    { plsNone - the whole program is not active
      plsWaiting - the program is running (or is ready to run), but the time/event
                   of  the line did not come (yet)
      plsRunning - the commands of the command line are just beeing executed
                   (in this state should be only for very short time, the
                   user of the line information should set the state to plsDone
                   as soon as the info is not needed anymore; in the case of
                   event lines, plsWaiting should be set again if the line can
                   be executed repeatedly)
      plsDone    - the line commands were successfully executed (and should not
                   be normally executed again during this program run, otherwise
                   plsWaiting should be set again).
      plsFailed  - the line commands were tried to execute but failed
      plsSkipped - the line commands were skipped: time passed/event occured
                   but the commands were not executed, set to this value if
                   user did not changed the state from plsRunning to plsWaiting
                   (for repeated event lines), plsDone or plsFailed }

type
  TSequenceKind = (skAAA, skStandalone);
{/v0.49}

{v0.50}
type
  TDataLinesName = string[40];
  TDataLinesViewName = string[40];
  TSamplingKind = (skPacket, skPoll);
{/v0.50}

{v0.50}{channelsu ulanrecs.lst}
type
  TFileFormatKind = (fkBinary, fkText, fkDOSMikro);

  TDeviceAlias = string;
{/v0.50}
{v0.59}
const
  ModuleAddrStrLen = 2;
{/v0.59}
{v0.61}
type
  TComposeCalibrationType = (cctAverage);

const
  { Calibration file extension }
  UlcExt = '.ULC';
{/v0.61}
{v0.62}
const
  CalibrationFileDialogFilter = 'Data file (*.ULF)|*.ULF|Calibration file (*.ULC)|*.ULC';
  CalibrationFilesMask = '*' + UlfExt + ';*' + UlcExt;
{/v0.62}
implementation

end.
