(*:Common constants, variables, and types for the GpSysHook DLL and component
   wrappers.

   @author Primoz Gabrijelcic
   @desc <pre>
   (c) 2001 Primoz Gabrijelcic
   Free for personal and commercial use. No rights reserved.

   Author            : Primoz Gabrijelcic
   Creation date     : 2001-09-25
   Last modification : 2001-10-10
   Version           : 1.02
</pre>*)(*
   History:
     1.02: 2001-10-10
       - Added CBT hook to the list of supported hooks.
     1.01: 2001-10-06
       - Documented.
     1.0: 2001-09-25
       - Created and released.
*)

unit GpSysHookCommon;

interface

uses
  Windows;

{Error codes returned from GpSysHook.AttachReceiver, GpSysHook.DetachReceiver,
  and GpSysHookLoader.LoadHookDLL.
}
const
  GPHOOK_FIRST_ERROR = 0;

  //:No error.
  GPHOOK_ERR_NO_ERROR
    = GPHOOK_FIRST_ERROR;
  //:DLL doesn't export all required functions.
  GPHOOK_ERR_NO_EXPORTS
    = GPHOOK_ERR_NO_ERROR-1;
  //:Receiver already registered.
  GPHOOK_ERR_ALREADY_REGISTERED
    = GPHOOK_ERR_NO_EXPORTS-1;
  //:Receiver not registered.
  GPHOOK_ERR_NOT_REGISTERED
    = GPHOOK_ERR_ALREADY_REGISTERED-1;
  //:Too many receivers.
  GPHOOK_ERR_TOO_MANY_RECEIVERS
    = GPHOOK_ERR_NOT_REGISTERED-1;
  //:System hook already installed.
  GPHOOK_ERR_ALREADY_HOOKED
    = GPHOOK_ERR_TOO_MANY_RECEIVERS-1;

  GPHOOK_LAST_ERROR = GPHOOK_ERR_ALREADY_HOOKED;

var
  //:Error codes for the correcsponding error messages.
  GpHookErrors: array [GPHOOK_LAST_ERROR..GPHOOK_FIRST_ERROR] of string;

type
  //:Implemented hooks.
  TGpHookType = (htShell, htKeyboard, htMouse, htCBT);

implementation

resourcestring
  sNoError           = 'No error.';
  sNoExports         = 'DLL doesn''t export all required functions.';
  sAlreadyRegistered = 'Receiver already registered.';
  sNotRegistered     = 'Receiver not registered.';
  sTooManyReceivers  = 'Too many receivers.';
  sAlreadyHooked     = 'System hook already installed.';

initialization
  GpHookErrors[GPHOOK_ERR_NO_ERROR]           := sNoError;
  GpHookErrors[GPHOOK_ERR_NO_EXPORTS]         := sNoExports;
  GpHookErrors[GPHOOK_ERR_ALREADY_REGISTERED] := sAlreadyRegistered;
  GpHookErrors[GPHOOK_ERR_NOT_REGISTERED]     := sNotRegistered;
  GpHookErrors[GPHOOK_ERR_TOO_MANY_RECEIVERS] := sTooManyReceivers;
  GpHookErrors[GPHOOK_ERR_ALREADY_HOOKED]     := sAlreadyHooked;
end.
