unit ShowMsg;
interface
uses
  {v0.40}Windows, {/v0.40 WinTypes, WinProcs, }
  Forms, SysUtils, Controls
  {v0.24}, Msgu{/v0.24 , MyType, TVType}
  {v0.28}, Language{/v0.28};

const

{  smError = 1;
  smInfo = 2;
  smYesNo = 3;
  smNoYes = 4;}
  smShowMessageCounter = 5;

function ShowMessage(msg: string; what: longint; hc: word): word;
procedure SysError(msg: string);

implementation
const
  ShowMessageCounter :word = 0;

function ShowMessage(msg:string; what:longint; hc:word):word;
var
  {v0.29}
  title:shortstring;
  ms: shortstring;
  {/v0.29 title: string;}
  t,p:array[0..255]of char;
  flags:longint;
  r:integer;
begin
  {v0.28}
  {msg := GetTxt(msg);}
  ms := msg;
  {/v0.28}
  if what <> smShowMessageCounter then begin
    title := '';
    flags := 0;
    case what of
      smError: begin
        title := GetTxt({#}'Error');
        flags := MB_OK + MB_ICONEXCLAMATION;
      end;
      smYesNo: begin
        title := GetTxt({#}'Confirmation');
        flags := MB_YESNO + MB_ICONQUESTION;
      end;
      smNoYes: begin
        title := GetTxt('Confirmation');
        flags := MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2;{messagbox}
      end;
      smInfo: begin
        title := GetTxt({#}'Info');
        flags := MB_ICONINFORMATION + MB_OK;
      end;
      smYesNoCancel: begin
        title := GetTxt('Confirmation');
        flags := MB_ICONQUESTION + MB_YESNOCANCEL;
      end;
      smFileModifiedSave: begin
        if ms = '' then
          ms := GetTxt({#}'File modified. Save changes?')
        else
          ms := ms + GetTxt({#}' modified. Save changes?');
        title := GetTxt('Confirmation');
        flags := MB_ICONQUESTION + MB_YESNOCANCEL;
      end;
    end;
    inc(ShowMessageCounter);
    r := Application.MessageBox(StrPCopy(p, ms), StrPCopy(t, title), flags);
    case r of
      mrOK: r := cmOK;
      mrYes : r := cmYes;
      mrNo : r := cmNo;
      mrCancel: r := cmCancel;
    end;
    ShowMessage := r;
    dec(ShowMessageCounter);
  end else begin
    ShowMessage := ShowMessageCounter;
  end;
end;

procedure SysError(msg:string);
begin
  ShowMessage(msg, smError,0);
end;

end.
