unit ULNPType;
{ ULNP channel device property description record. Used in programs to
  hold values that should be assigned at given time. }
interface

uses
  UlanType, ULRecTyp;{ULREC.LST}

const
  ULNPID = ord('U') + 256*ord('L') + 256*256*ord('N') + 256*256*256*ord('P');

type
  TULNPRec = packed record {<Caption="Channel dev.prop." Uses=ULDPType
    Enabled=1 Visible=1 HasRecName=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PropIDStr: TModulePropIDStr;{<Enabled=1 Type=ULEnum ValuesSourceRecID=ULDPID>}
     { System wide unique name of the device property in ULD-ULDP lists }
    Value: AnsiString;
  end;
  PULNPRec = ^TULNPRec;

implementation

end.
