{Author:	Poul Bak}
{}
{Copyright  1999 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}
{}
{Component Version: 2.00.00.00}
{}
{PBSpinEdit is a standard Delphi Edit component with Alignment and
mouse-AutoSelect-all.}
{Can replace standard components without any disadvantages.}

{Supports Windows 95, 98 and NT.}
{Supports Default-Button click. (Standard SpinEdit does not).}

unit PBSpinEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin;

type
  TPBSpinEdit = class(TSpinEdit)
  private
    { Private declarations }
    FAlignment : TAlignment;
    FEnter : Boolean;
    FVersion : string;
    procedure SetAlignment(Value: TAlignment);
    procedure SetVersion(Value: String);
  protected
    { Protected declarations }
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure DoEnter; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
  published
  {Set Alignment to: taLeftJustify, taCenter or taRightJustify.}
  {Default : taLeftJustify.}
  {Supports Windows 95, 98 and NT.}
     property Alignment: TAlignment read FAlignment write SetAlignment;
  {Default: True.}
  {Set AutoSelect to True to select all text when you set focus:}
  {Notice that when you set focus using the mouse, all text is also selected -
  unlike standard Delphi components that only selects all when setting focus with <tab>.}
  {When a form has a defaultbutton and you press <enter>, the click event
  triggers and focus is returned to the edit control which autoselect all.}
        property AutoSelect;
  {Read only. }
        property Version: String read FVersion write SetVersion;
end;

procedure Register;

implementation

constructor TPBSpinEdit.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	Width := 100;
	FAlignment := taLeftJustify;
	FVersion := '2.00.00.00';
	Text := '';
	FEnter := False;
end;

procedure TPBSpinEdit.CreateParams(var Params: TCreateParams);
const
  Alignments: array[TAlignment] of Word = (ES_LEFT, ES_RIGHT, ES_CENTER);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE or Alignments[FAlignment];
end;

procedure TPBSpinEdit.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) or (ssLeft in Shift) then
  begin
          if FEnter = True then
          begin
                  FEnter := False;
                  if AutoSelect then SelectAll;
          end;
  end;
  inherited MouseDown(Button, Shift, X, Y);
end;

procedure TPBSpinEdit.DoEnter;
begin
  inherited DoEnter;
  if csLButtonDown in ControlState then FEnter := True;
  if AutoSelect then SelectAll;
end;

procedure TPBSpinEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  FEnter := False;
end;

procedure TPBSpinEdit.SetAlignment(Value: TAlignment);
begin
  if FAlignment <> Value then
  begin
          FAlignment := Value;
          RecreateWnd;
  end;
end;

procedure TPBSpinEdit.KeyPress(var Key: Char);
var
  SelSt, SelLe, t : integer;
  DefaultButton : Boolean;
begin
  if Key =#13 then
  begin
    DefaultButton := False;
    SelSt := SelStart;
    SelLe := SelLength;
    if Owner is TForm then with (Owner as TForm) do
    begin
            Key :=#0;
            for t := 0 to ControlCount - 1 do
            begin
                    if (Controls[t] is TButton)then
                            if ((Controls[t] as TButton).Default = True) then
                            begin
                                    DefaultButton := True;
                                    DefocusControl(Self, True);
                                    (Controls[t] as TButton).Setfocus;
                                    (Controls[t] as TButton).Click;
                            end;
            end;
            if DefaultButton then
            begin
                    Self.Setfocus;
                    if AutoSelect then SelectAll
                    else
                    begin
                            SelStart := SelSt;
                            SelLength := SelLe;
                    end;
            end
            else MessageBeep(0);
    end;
  end;
  inherited KeyPress(Key);
end;

procedure TPBSpinEdit.SetVersion(Value: String);
begin
	{ Read only! }
end;


procedure Register;
begin
	RegisterComponents('PB', [TPBSpinEdit]);
end;

end.

