unit CalibrationFrm;{v0.64}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
  UlanType, ULRecTyp, ULObju,ULObjEditPanelu, Grids, XStringGrid,
  ULStringGrid, LsFileExplorer26, ComCtrls, Spectrum, CalDatau,

  UCPType, UCPObju, UCFType, UCFObju, UCFRType, UCFRObju
  {v0.65}
  ,UCPLType, UCPLObju, ExtComDl //todo.txt ulfobju
  {/v0.65}
  ;

type
  TCalibrationForm = class(TForm)
    CalibrationTypeRadioGroup: TRadioGroup;
    SaveButton: TButton;
    FileNameEdit: TEdit;
    Label1: TLabel;
    FilesGrid: TULStringGrid;
    PeaksGrid: TULStringGrid;
    PeakLevelsGrid: TULStringGrid;
    PeaksHeadEditPanel: TULObjEditPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    AddBtn: TButton;
    DelBtn: TButton;
    DirTreeCombo: TLsDirTreeCombo26;
    FileListView: TLsFileListView26;
    ComposePeaksBtn: TButton;
    CreatePeakLevelBtn: TButton;
    ESaveDialog: TESaveDialog;
    SelectFileNameBtn: TButton;
    procedure SaveButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure FileNameEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DelBtnClick(Sender: TObject);
    procedure ComposePeaksBtnClick(Sender: TObject);
    procedure PeaksGridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure CreatePeakLevelBtnClick(Sender: TObject);
    procedure SelectFileNameBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    FCalData: TCalData;
    function GetCalData: TCalData;
    function GetCalDataName: string;
    procedure UpdateControls;
    procedure SetCalData(ACalData: TCalData);
    procedure SetCalDataName(const AFileName: string);
  public
    { Public declarations }
    property CalData: TCalData read GetCalData write SetCalData;
    property CalDataName: string read GetCalDataName write SetCalDataName;
  end;

const
  CalibrationForm: TCalibrationForm = nil;

function ComposeCalibrationFormExecute(const ADirName: string;
  {/v0.65}AFileList: TStringList; {/v0.65} var AFileName: string;
  var CalibrationType: TCalibType): boolean;

implementation

{$R *.DFM}

function ComposeCalibrationFormExecute(const ADirName: string; {/v0.65}AFileList: TStringList; {/v0.65} var AFileName: string; var CalibrationType: TCalibType): boolean;
var
  ucfr: TUCFRObj;
  i: integer;
begin
  if CalibrationForm = nil then
    CalibrationForm := TCalibrationForm.Create(Application);
  CalibrationForm.CalibrationTypeRadioGroup.ItemIndex := ord(CalibrationType);
  CalibrationForm.FileNameEdit.Text := AFileName;
  CalibrationForm.DirTreeCombo.OpenPath(ADirName);
  CalibrationForm.FileListView.Directory := ADirName;
  CalibrationForm.ESaveDialog.InitialDir := ADirName;
  {v0.65}
  if (AFileList <> nil) and (AFileList.Count > 0) then begin
    for i := 0 to AFileList.Count - 1 do begin
      ucfr := TUCFRObj(CalibrationForm.CalData.ULC_UCF.Add(UCFRID));
      ucfr.FileName := AFileList[i];
    end;
  end;
  {/v0.65}
  if CalibrationForm.ShowModal = mrOK then begin
    CalibrationType := TCalibType(CalibrationForm.CalibrationTypeRadioGroup.ItemIndex);
    AFileName := CalibrationForm.FileNameEdit.Text;
    Result := true;
  end else begin
    Result := false;
  end;
end;

function TCalibrationForm.GetCalDataName: string;
begin
  Result := CalData.FileName;
end;

procedure TCalibrationForm.SetCalDataName(const AFileName: string);
begin
  if FileExists(AFileName) and (AFileName <> CalData.FileName) then begin
    CalData.SetFileName(AFileName, omRead);
  end else begin
    CalData.ChangeFileName(AFileName);
  end;
end;

function TCalibrationForm.GetCalData: TCalData;
begin
  if FCalData = nil then begin
    FCalData := TCalData.Create(FileNameEdit.Text, omRead);

    //CreateOrOpenDataFile(CalDataName, FCalData);//: boolean;
    //if CalDataName = '' then
    //  FCalData.ULF.FileName := 'NONAME.CAL';
  end;
  Result := FCalData;
end;

procedure TCalibrationForm.SetCalData(ACalData: TCalData);
begin
  if FCalData = ACalData then
    exit;
  if FCalData <> nil then
    FCalData.Free;
  FCalData := ACalData;
  if FCalData <> nil then begin
    FileNameEdit.Text := FCalData.FileName;
  end else begin
    FileNameEdit.Text := '';
  end;
  UpdateControls;
end;

procedure TCalibrationForm.SaveButtonClick(Sender: TObject);
begin
  if FileNameEdit.Text = '' then begin
    ShowMessage('Enter name for the composed calibration file');
    ModalResult := 0;
    exit;
  end;
  CalData.Save;
end;                                 // ulobju filescanner   filedropper


procedure TCalibrationForm.FormActivate(Sender: TObject);
begin
  {v0.65}
  UpdateControls;
 {/v0.65
  FilesGrid.Obj := CalData.ULC_UCF;
}
end;

{v.65}
procedure TCalibrationForm.UpdateControls;
begin
  FilesGrid.Obj := CalData.ULC_UCF;
  PeaksGrid.Obj := CalData.ULC_UCP;
  PeakLevelsGrid.Obj := nil;
end;
{v0.65}

procedure TCalibrationForm.AddBtnClick(Sender: TObject);
var
  f: TUCFRObj;
  v: TListItem;
begin
//tlistview
  v := FileListView.Selected;
  while v <> nil do begin
    f := TUCFRObj(FilesGrid.Obj.Add(UCFRID));
    f.FileName := v.Caption;//FileListView.SelectedItem;
    v := FileListView.GetNextItem(v, sdAll, [isSelected]);
  end;
end;

procedure TCalibrationForm.FileNameEditChange(Sender: TObject);
begin
  CalData.ChangeFileName(FileNameEdit.Text);
end;

procedure TCalibrationForm.FormDestroy(Sender: TObject);
begin
  CalData := nil;
  CalibrationForm := nil;
end;

procedure TCalibrationForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

{v0.65}
procedure TCalibrationForm.DelBtnClick(Sender: TObject);
//var o: TULObj;
begin
  FilesGrid.Obj.ChildsDelete(0, rfSelected);//ulrectyp
//  o := FilesGrid.Obj.ActiveChild;
//  if o <> nil then
//    o.Free;
end;

procedure TCalibrationForm.ComposePeaksBtnClick(Sender: TObject);
begin
  CalData.ComposePeaks;
end;


procedure TCalibrationForm.PeaksGridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
var o: TULObj;
begin
   o := PeaksGrid.Obj.ActiveChild;
   if o <> nil then
     PeakLevelsGrid.Obj := o;
end;

procedure TCalibrationForm.CreatePeakLevelBtnClick(Sender: TObject);
var
  ucpl: TUCPLObj;
  o: TULObj;
begin
  o := PeakLevelsGrid.Obj;
  if o <> nil then begin
    ucpl := TUCPLObj(o.Add(UCPLID));
  end;
end;

{/v0.65}
procedure TCalibrationForm.SelectFileNameBtnClick(Sender: TObject);
begin
  if FileNameEdit.Text <> '' then
    ESaveDialog.FileName := FileNameEdit.Text;
  if ESaveDialog.Execute then begin
    FileNameEdit.Text := ESaveDialog.FileName;
    if FileExists(ESaveDialog.FileName) then begin
      CalData.SetFileName(ESaveDialog.FileName, omRead);
      UpdateControls;
    end;
  end;
end;

procedure TCalibrationForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if FCalData <> nil then
    CanClose := FCalData.CanClose;
end;

end.
