unit DataFileu;{v0.64}{v0.66 really used}
{ Common ancestor for acquisition related data holding files:
  Spectrum . TAcqData and CalDatau . TCalData }
interface
uses
  Windows, Messages, SysUtils, Classes, {$IFNDEF CONSOLE} Forms, {$ENDIF}
  UtlType, Language,  {$IFNDEF CONSOLE} FileMenuHdl, {$ENDIF} Msgu,

  UlanType, UlanGlob, ULRecTyp, ULObju, ULFObju,
  ULAType, ULAObju, ULSQType, ULSQObju, ULADType, ULADObju, UDLRType, UDLRObju,
  UDLSType, UDLSObju, ULIType, ULIObju;

type

  TDataFile = class(TObject)
  private

  protected
    { TULFObj root (all ULObj files have it); owner of data root objects in
      descendants (ULA, ULC); created by reading  FileName }
    FULF: TULFObj;
    { omCreate - creating (acquiring for TAcqData) data;
      omRead - reading (eventually modifying);
      omReadOnly - only reading data }
    FMode: TOpenMode;

    {$IFNDEF CONSOLE}
    FOwnerForm: TForm;
      { if non nil, then this form will destroy the data upon its destroying }
    {$ENDIF}

    { Set at the end of constructor true, prevents saving incorrectly read
      file during destroy }
    FCreatedOK: boolean;

    property CreatedOK: boolean read FCreatedOK write FCreatedOK;
    procedure WMAppMessage(var Message: TMessage); message WM_APPMESSAGE;
    procedure ObjUpdated(AObj: TULObj); virtual;
    procedure ObjDestroyed(AObj: TULObj); virtual;
    procedure ULFFree; virtual;
    procedure ULFCreate; virtual;
    procedure ULFCreated; virtual;
    function GetNonameFileName: string; virtual;
    function GetFileExt: string; virtual; abstract;
    function GetTemplateExt: string; virtual; abstract;
    function IsAllowedExt(const AExt: string): boolean; virtual;
    function HasData: boolean; virtual; abstract;
    procedure DiscardData; virtual; abstract;

    function GetFileName: string;
  public
    constructor Create(const AFileName: string; AMode: TOpenMode); virtual;
    procedure SetFileName(const AFileName: string; AMode: TOpenMode); virtual;
    { Just change ULF.FileName without any immediate saving (used after
      starting from template, when name of the file to be acquired
      is already known (AAA). Extension will be automatically be changed
      to .ULF }
    procedure ChangeFileName(const AFileName: string); virtual;
    { Saves current data to AFileName and set it as the current file. }
    procedure SaveTo(const AFileName: string); virtual;
    destructor Destroy; override;
    function CanClose: boolean; virtual;
    procedure CreateTemplate(const AFileName: string); virtual;
    procedure Save;

    property ULF: TULFObj read FULF;
    property Mode: TOpenMode read FMode;
    {$IFNDEF CONSOLE}
    property OwnerForm: TForm read FOwnerForm write FOwnerForm;
    {$ENDIF}
    property FileExt: string read GetFileExt;
    property TemplateExt: string read GetTemplateExt;
    property FileName: string read GetFileName;
  end;

{$IFNDEF CONSOLE}
type
  TObjHandler = class(TObject)
    procedure ValuesSourceNeeded(Sender: TObject);
    procedure ChildCreated(Sender: TObject);
    procedure CheckIn(AObj: TULObj);
  end;

function ObjHandler: TObjHandler;
{$ENDIF}

implementation
uses
  Modulu;
  
{TDataFile.}
constructor TDataFile.Create(const AFileName: string; AMode: TOpenMode);
begin
  inherited Create;
  if AMode = omCreateTemplate then begin
    CreateTemplate(AFileName);
  end else begin
    SetFileName(AFileName, AMode);
  end;
  FMode := AMode;
  FCreatedOK := true;
end;

procedure TDataFile.ULFCreate;
begin
  FULF := TULFObj.Create(nil);
end;

procedure TDataFile.ULFCreated;
begin
end;

procedure TDataFile.ULFFree;
begin
  FULF.Free;
  FULF := nil;
end;

procedure TDataFile.CreateTemplate(const AFileName: string);
begin
  ULFFree;
  ULFCreate;
  ULFCreated;
  ULF.FileName := ChangeFileExt(AFileName, GetTemplateExt);
end;

//function TDataFile.GetFileExt: string;
//begin
//  Result := ULFExt;
//end;

//function TDataFile.GetTemplateExt: string;
//begin
//  Result := ULTExt;
//end;

function TDataFile.IsAllowedExt(const AExt: string): boolean;
begin
  Result := AExt = FileExt;
end;

function TDataFile.GetNonameFileName: string;
begin
  Result := DataDir + 'NONAME' + GetFileExt;
end;

procedure TDataFile.SetFileName(const AFileName: string; AMode: TOpenMode);
var
  e: string;
  fn: string;
  rfn: string;
  i: integer;
begin
  FMode := AMode;
  e := UpperCase(ExtractFileExt(AFileName));
  fn := AFileName;
  if FMode <> omCreate then begin
    if (AFileName <> '') and (not FileExists(AFileName)) then
      raise EFOpenError.Create(GetTxt({#}'Can not open file') + ' ' + AFileName);
    ULFFree;
    ULFCreate;
    if AFileName <> '' then begin
      if IsAllowedExt(e)//(e = ULFExt) or (e = ASCExt) or (e = ULTExt) or (e = ULCExt)
      then
        ULF.LoadFromFile(AFileName);
    end;

    if FMode = omReadOnly then
      ULF.ReadOnly := true;
    ULFCreated;
    if AFileName <> '' then begin
      if not IsAllowedExt(e)//(e <> GetFileExt) ULFExt) and (e <> AscExt) and (e <> ULTExt) and (e <> ULCExt)
      then begin
        //ULA.FindOrAdd(ULADID, '');
        //ULAD.Update;
  //      if TryConvertFromFile(AFileName, ULA, ActiveData) then begin
  //        ULAD.Update;
  //      end else begin
          raise EInvalidFileExt.Create(GetTxt({#}'Invalid file extension') + ': ' + AFileName);
  //      end;
  //      ULF.FileName := ReplaceExt(AFileName, ULFExt, true);
      end;
    end;
//    ULAD.CurDataSizeUpdate;
//    ScanData;
//    {$IFNDEF CONSOLE}
//    if AutofixData then begin
//      ChkAcqData(Self, true);
//    end;
//    {$ENDIF}
  end else begin

    if not IsAllowedExt(e)//(e <> GetFileExt)//ULFExt) and (e <> ULTExt) and (e <> ULCExt)
    then
      raise EInvalidFileExt.Create(GetTxt({#}'Invalid file extension') + ': ' + AFileName);
    ULFFree;
    ULFCreate;
    if FileExists(fn) then begin
      ULF.LoadFromFile(fn);
    end else begin
      raise ETemplateNotFound.Create(GetTxt({#}'Template Not Found') + ': ' + fn);
    end;
    ULFCreated;
//    CheckULRecords;
//    FTemplateULADCount := ULAD.Count;
    fn := GetNonameFileName;
    ULF.FileName := fn;
    {$IFNDEF CONSOLE}
//    CheckChannel;
    {$ENDIF}
    {
    try
      for i := 0 to ULAD.Count - 1 do begin
        ud := ULAD[i].ULAD;
        rfn := RawFileName[i];
        ud.Data := TFileStream.Create(rfn, fmCreate);
      end;
    except
      on EFCreateError do begin
        raise EAcqAlreadyOpened.Create(GetTxt('Acquisition window already opened for') +
          ' ' + ULI.ChannelName);
      end;
    end;
    }
  end;
  {$IFNDEF CONSOLE}
  ObjHandler.CheckIn(ULF);
  {$ENDIF}
end;

procedure TDataFile.WMAppMessage(var Message: TMessage);
begin
  case Message.wParam of
    cmULObjUpdated: ObjUpdated(TULObj(Message.LParam));
    cmULObjDestroyed: ObjDestroyed(TULObj(Message.LParam));
  end;
//  inherited;
end;

procedure TDataFile.ObjUpdated(AObj: TULObj);
begin
end;

procedure TDataFile.ObjDestroyed(AObj: TULObj);
begin
end;

procedure TDataFile.ChangeFileName(const AFileName: string);
begin
  ULF.FileName := ChangeFileExt(AFileName, FileExt);
end;

procedure TDataFile.SaveTo(const AFileName: string);
{ Saves current data to AFileName and set it as the current file. }
var
  ext: string;
begin
  ext := UpperCase(ExtractFileExt(AFileName));
  if not IsAllowedExt(ext) then begin
    raise EInvalidFileExt.Create(GetTxt({#}'Unsupported file extension') + ': ' + AFileName);
  end else begin
    ULF.SaveToFile(AFileName);
  end;
end;

destructor TDataFile.Destroy;
begin
  inherited;
end;

function TDataFile.CanClose: boolean;
begin
  Result := true;
  {$IFNDEF CONSOLE}
  if (ULF <> nil) then begin
    if (pos('NONAME', ULF.FileName) <> 0) then
    begin
      if HasData then begin
        if not FMH.SaveAs then begin
          if ShowMessage(GetTxt({#}'Discard data?'), smNoYes, 0) <> cmYes then begin
            Result := false;
          end else begin
            DiscardData;
          end;
        end;
      end else begin
        if ULF.Modified then begin
          if not FMH.SaveAs then begin
            if ShowMessage(GetTxt({#}'Discard changes?'), smNoYes, 0) <> cmYes then begin
              Result := false;
            end else begin
              ULF.Modified := false;
            end;
          end;
        end;
      end;
    end else begin
      if ULF.Modified then begin
        if ULF.ReadOnly then begin
          case ShowMessage(ULF.FileName + ' ' + GetTxt({#}'was opened Read Only but modified.') +
            ' ' + GetTxt({#}'Save to other file?'), smYesNoCancel, 0) of
            cmCancel: CanClose := false;
            cmYes: begin
              try
                if not FMH.SaveAs then begin
                  CanClose := false;
                end else begin
                  ULF.Modified := false;
                end;
              finally
              end;
            end;
            cmNo: ULF.Modified := false;
          end;
        end else begin
          case ShowMessage(ULF.FileName, smFileModifiedSave,0) of
            cmCancel: CanClose := false;
            cmNo: ULF.Modified := false;
          end;
        end;
      end;
    end
  end;
  {$ENDIF}
end;

function TDataFile.GetFileName: string;
begin
  Result := '';
  if ULF <> nil then
    Result := ULF.FileName;
end;

procedure TDataFile.Save;
begin        //ulobju
  if ULF <> nil then
    ULF.Save;
end;
{/TDataFile.}

{TObjHandler.}
{$IFNDEF CONSOLE}
procedure TObjHandler.CheckIn(AObj: TULObj);
var
  o: TULObj;
  i: integer;

begin
  if (AObj is TULADObj) then begin
    AObj.ObjDesc.OnValuesSourceNeeded := ValuesSourceNeeded;
  end else if (AObj is TUDLRObj) then begin
    AObj.ObjDesc.OnValuesSourceNeeded := ValuesSourceNeeded;
  end else if (AObj is TULAObj) or (AObj is TUDLSObj) {v0.66}or (AObj is TULFObj){v0.66} then begin
    AObj.ObjDesc.OnChildCreated := ChildCreated;
    for i := 0 to AObj.ChildCount - 1 do begin
      o := AObj.Childs[i];
      if (o.RecID = ULADID) or (o.RecID = UDLRID) then
        CheckIn(o);
      if o.RecID = ULIID then
        CheckIn(o.FindOrAdd(UDLSID, ''));
    end;
  end;
end;

procedure TObjHandler.ChildCreated(Sender: TObject);
begin
  if (Sender is TULADObj) or (Sender is TUDLRObj) then
    CheckIn(TULObj(Sender))
end;

procedure TObjHandler.ValuesSourceNeeded(Sender: TObject);
var
  obj, o: TULObj;
  devicef, valuef: TULObjField;
begin
  if (Sender is TULADObj) or (Sender is TUDLRObj) then begin
    obj := TULObj(Sender);
    valuef := obj.Fields[obj.MessageInfo];
    if valuef.FldDesc.Name = 'PropDesc' then begin
      devicef := Obj.FindField('DeviceName');
      if Modules.ULD.HasChildWithFieldUsrValue('DeviceName', devicef.AsUsrString, o) then
        valuef.FldDesc.ValuesSource := o;
    end;
  end;
end;

const
  FObjHandler: TObjHandler = nil;

function ObjHandler: TObjHandler;
begin
  if FObjHandler = nil then
    FObjHandler := TObjHandler.Create;
  Result := FObjHandler;
end;
{$ENDIF}
{/TObjHandler.}

end.
