unit MargDial;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, UlanType, UlanGlob;

type
  TMarginsDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    FromEdit: TEdit;
    ToEdit: TEdit;
    AMinEdit: TEdit;
    AMaxEdit: TEdit;
    FromLabel: TLabel;
    ToLabel: TLabel;
    AMin: TLabel;
    AMaxLabel: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetPars(var AUserViewPar:TUserViewLimit);
    procedure GetPars(var AUserViewPar:TUserViewLimit);
  end;

var
  MarginsDialog: TMarginsDialog;

function ExecuteMarginsDialog(var AUserViewPar:TUserViewLimit):TModalResult;

implementation

procedure TMarginsDialog.SetPars(var AUserViewPar:TUserViewLimit);
var s:string;
begin
  str(AUserViewPar.Min.X:10:2, s);
  FromEdit.Text := trim(s);
  str(AUserViewPar.Max.X:10:2, s);
  ToEdit.Text := trim(s);
  str(AUserViewPar.Min.Y:10:2, s);
  AMinEdit.Text := trim(s);
  str(AUserViewPar.Max.Y:10:2, s);
  AMaxEdit.Text := trim(s);
end;

procedure TMarginsDialog.GetPars(var AUserViewPar:TUserViewLimit);
var code:integer;
begin
  val(trim(FromEdit.Text), AUserViewPar.Min.X, code);
  val(trim(ToEdit.Text), AUserViewPar.Max.X, code);
  val(trim(AMinEdit.Text), AUserViewPar.Min.Y, code);
  val(trim(AMaxEdit.Text), AUserViewPar.Max.Y, code);
end;

function ExecuteMarginsDialog(var AUserViewPar:TUserViewLimit):TModalResult;
begin
  ExecuteMarginsDialog := mrCancel;
  MarginsDialog.SetPars(AUserViewPar);
  if MarginsDialog.ShowModal = mrOK then begin
    ExecuteMarginsDialog := mrOK;
    MarginsDialog.GetPars(AUserViewPar);
    {v1.05}
    CurUserViewLimit := AUserViewPar;
    {/v1.05}
  end;
end;

{$R *.DFM}

end.
