program tom2txt;
uses dos;
procedure DoTom2txt(srcFile: string);
var
  f: file of longint;
  dest: text;
  l: longint;
  t: longint;
  d,n,e:string;
  fn: string;
  destFile:string;
  r: single;
  coef: single;
begin

  fsplit(srcFile, d, n, e);
  if e = '' then
    srcFile := d + n + '.tom';

  assign(f, srcFile);
  {$I-}
  reset(f);
  if ioresult <> 0 then begin
    writeln('Can not open file ' + srcFile);
    halt;
  end;
  seek(f, 116);
  coef := 125E-9;
  if ioresult<> 0 then begin
    writeln('Too small source file ' + srcFile);
    halt;
  end;
  destFile := d + n + '.txt';
  assign(dest, destFile);
  rewrite(dest);
  if ioresult <> 0 then begin
    writeln('Can not write to file ' + destFile);
    halt;
  end;

  t := 0;
  repeat
    read(f, l);
    if ioresult <> 0 then
      break;

    r := l * coef;
    writeln(dest, t / 1000, ',', r);
    t := t + 20;
  until false;

  close(f);
  close(dest);

end;

begin
  if paramcount = 0 then begin
    writeln('Usage: tom2txt srcfile[.tom]');
    writeln('Converts .tom file to ascii .txt file');
  end else begin
    DoTom2txt(paramstr(1));
  end;
end.