unit AnalSetupFrm;{ Setup form for sample chromatographic analysis. }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls,
  ExtComDl,
  UtlType, WinUtl, Msgu, Language,
  ULRecTyp, ULObju, ULEdUtl, ULEdFrm,
  ULMType, ULIType,
  UlanType, UlanGlob, Spectrum
  ;

type
  TAnalSetupForm = class(TULEditForm)
    Panel1: TPanel;
    PageControl: TPageControl;
    ULATabSheet: TTabSheet;
    SamplePanel: TPanel;
    Label1: TLabel;
    SampleDescLabel: TLabel;
    AmountLabel: TLabel;
    ISTDAmountLabel: TLabel;
    InjectionVolumeLabel: TLabel;
    SampleNameEdit: TEdit;
    SampleDescEdit: TMemo;
    DivideFactorEdit: TEdit;
    ISTDAmountEdit: TEdit;
    InjectionVolumeEdit: TEdit;
    CalibrationStandardEdit: TCheckBox;
    ULMTabSheet: TTabSheet;
    ULITabSheet: TTabSheet;
    Panel2: TPanel;
    OKBtn: TButton;
    CancelBtn: TButton;
    HelpBtn: TButton;
    MethodTemplateEdit: TEdit;
    CalibrationFileNameEdit: TEdit;
    MethodFileNameEdit: TEdit;
    DilutionLbl: TLabel;
    DilutionEdit: TEdit;
    BaseMinIntervalEdit: TEdit;
    BaseMinIntervalLbl: TLabel;
    BaseMaxDiffLbl: TLabel;
    BaseMaxDiffEdit: TEdit;
    MinPeakHeightEdit: TEdit;
    MinPeakHeightLbl: TLabel;
    MinPeakWidthLbl: TLabel;
    MinPeakWidthEdit: TEdit;
    UseNegativePeaksEdit: TCheckBox;
    CalcAmountsEdit: TCheckBox;
    UseCalibrationFileEdit: TCheckBox;
    UseCalibrationFileLbl: TLabel;
    UseInternalStandardEdit: TCheckBox;
    FactorLbl: TLabel;
    FactorEdit: TEdit;
    CalibrationFileAgeEdit: TEdit;
    CalibrationFileAgeLbl: TLabel;
    ColumnEdit: TEdit;
    ColumnLbl: TLabel;
    MobilePhaseLbl: TLabel;
    MobilePhaseEdit: TEdit;
    FlowRateUnitEdit: TComboBox;
    FlowRateLbl: TLabel;
    FlowRateEdit: TEdit;
    DetectionEdit: TEdit;
    FlowRateUnitLbl: TLabel;
    DetectionLbl: TLabel;
    TemperatureLbl: TLabel;
    TemperatureEdit: TEdit;
    TemperatureUnitEdit: TComboBox;
    TemperatureUnitLbl: TLabel;
    MethodOpenDialog: TOpenDialog;
    MethodSaveDialog: TSaveDialog;
    CalibrationFileSelectDialog: TOpenDialog;
    MethodFilePanel: TPanel;
    MethodLoadFromBtn: TButton;
    MethodSaveToBtn: TButton;
    CalibrationFileBtn: TButton;
    InstrumentFilePanel: TPanel;
    InstrumentTemplateEdit: TEdit;
    InstrumentSaveDialog: TESaveDialog;
    InstrumentOpenDialog: TEOpenDialog;
    InstrumentFileNameEdit: TEdit;
    InstrumentLoadFromBtn: TButton;
    InstrumentSaveToBtn: TButton;
    ParametersBtn: TButton;
    ChannelNameEdit: TComboBox;
    Label2: TLabel;
    FileNameEdit: TEdit;
    FileNameLbl: TLabel;
    DurationEdit: TEdit;
    DurationLbl: TLabel;
    SamplingIntervalEdit: TEdit;
    Label3: TLabel;
    DateTimeEdit: TEdit;
    Bevel1: TBevel;
    Label4: TLabel;
    MultiplyFactorEdit: TEdit;
    MultiplyFactorLabel: TLabel;
    AmountEdit: TEdit;
    Label5: TLabel;
    UserNameEdit: TEdit;
    Label6: TLabel;
    DataLinesButton: TButton;
    SequenceKindEdit: TComboBox;
    Label7: TLabel;
    DefDataNameEdit: TEdit;
    Label8: TLabel;
    NoUnknownPeaksEdit: TCheckBox;
    Button1: TButton;
    SequenceTabSheet: TTabSheet;
    SequencePanel: TPanel;
    Label9: TLabel;
    Label10: TLabel;
    SequenceNameEdit: TEdit;
    SequenceDescEdit: TMemo;
    ApplyBtn: TButton;
    UndilutedISEdit: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure MethodLoadFromBtnClick(Sender: TObject);
    procedure MethodSaveToBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ParametersBtnClick(Sender: TObject);
    procedure CalibrationFileBtnClick(Sender: TObject);
    procedure InstrumentLoadFromBtnClick(Sender: TObject);
    procedure InstrumentSaveToBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DataLinesButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
  private
    { Private declarations }
    {v0.15}
    FFileName: TFileName;
    {/v0.15}
    {v0.53}
    FIsInModify: boolean;
    {/v0.53}
  protected
    {v0.25}
    FData: TAcqData;
    function GetData: TAcqData;
    {/v0.25
    Data: TAcqData;}
    procedure ComponentsToObj; override;
      { Copy values of visual edit components to properties of Obj TULObj }
    procedure ObjToComponents{v0.24}(AlsoFocused:boolean){/v0.24}; override;
      { Copy values of properties of Obj TULObj to visual edit components }
    {v0.25}
    procedure Loaded;override;
    {/v0.25}
    {v0.53}
    procedure SetModified(OnOff: boolean);override;
    function DoApply: boolean;
    function CheckApply: boolean;
    {/v0.53}
  public
    { Public declarations }
    {v0.25}
    property Data: TAcqData read GetData;
    {/v0.25}
    {v1.14}
    constructor Create(AOwner: TComponent); reintroduce;
    {/v1.14}
  end;

var
  AnalSetupForm: TAnalSetupForm;

implementation

{$R *.DFM}

{v0.25}
function TAnalSetupForm.GetData: TAcqData;
begin
  if FData = nil then begin{ulsqtype ulsqobju}
    if Obj = nil then begin
      Obj := CurULObj;
      CurULObj := nil;
    end;
    FData := TAcqData(Obj.MainUser);
  end;
  Result := FData;
end;
{/v0.25}

procedure TAnalSetupForm.ComponentsToObj;
 { Copy values of visual edit components to properties of Obj TULObj }
var
  m, i: TULObj;
begin
  {v0.53}
  Obj.DoChangeLock;
  try
  {/v0.53}
  inherited;
  if Obj.FindObj(ULMID, 0, '', m) then
    FormToULObj(Self, m, [], FObjRootFileDir);
  if Obj.FindObj(ULIID, 0, '', i) then
    FormToULObj(Self, i, [], FObjRootFileDir);
  {v0.53}
  finally
    Obj.DoChangeUnlock;
  end;
  {/v0.53}
end;

procedure TAnalSetupForm.ObjToComponents{v0.24}(AlsoFocused:boolean){/v0.24};
 { Copy values of properties of Obj TULObj to visual edit components }
var
  m, i: TULObj;
begin
  inherited;
  if Obj.FindObj(ULMID, 0, '', m) then
    ULObjToForm(m, Self, [], FObjRootFileDir);
  if Obj.FindObj(ULIID, 0, '', i) then
    ULObjToForm(i, Self, [], FObjRootFileDir);
  {v0.15}
  FileNameEdit.Visible := pos('NONAME', Data.ULF.FileName) > 0;
  FileNameLbl.Visible := FileNameEdit.Visible;
  {/v0.15}
end;

procedure TAnalSetupForm.OKBtnClick(Sender: TObject);
begin
  inherited;
  {v0.53}
  if not DoApply then
    exit;
  {/v0.53
  if FileNameEdit.Visible then begin
    FFileName := FileNameEdit.Text;
    if trim(FFileName) <> '' then begin
      FFileName := ChangeFileExt(DataDir + ExtractFileName(FileNameEdit.Text), ULFExt);
      if FileExists(FFileName) then begin
        if ShowMessage(GetTxt('File') + ' ' + FFileName + ' ' + GetTxt('Exists. Overwrite?'), smNoYes, 0) <> cmYes then begin
          ModalResult := 0;
          PageControl.ActivePage := ULATabSheet;
          FileNameEdit.SetFocus;
          exit;
        end;
      end;
      Data.ULF.FileName := FFileName;
    end;
  end;}
  DoOnOK;
end;

procedure TAnalSetupForm.CancelBtnClick(Sender: TObject);
begin
  inherited;
  DoOnCancel;
end;

procedure TAnalSetupForm.MethodLoadFromBtnClick(Sender: TObject);
begin 
  inherited;
  {v0.14}
  if Data.ULM.MethodTemplate <> '' then
    MethodOpenDialog.FileName := Data.ULM.MethodTemplate;
  if MethodOpenDialog.Execute then begin
    Data.MethodLoadFromFile(MethodOpenDialog.FileName);
    ULObjToForm(Data.ULM, Self, {v0.15}[]{/v0.15 [foOnlyFileNames]}, FObjRootFileDir);
{    MethodTemplateEdit.Text := RelativeFileName(FStartDir, Data.ULM.MethodTemplate);}
  end;
  {/v0.14}
end;

procedure TAnalSetupForm.MethodSaveToBtnClick(Sender: TObject);
begin
  inherited;
  {v0.14}
  if Data.ULM.MethodFileName <>  '' then
    MethodSaveDialog.FileName := Data.ULM.MethodFileName;
  if MethodSaveDialog.Execute then begin
    Data.MethodSaveToFile(MethodSaveDialog.FileName);
    ULObjToForm(Data.ULM, Self, [foOnlyFileNames], FObjRootFileDir);
{    MethodFileNameEdit.Text := RelativeFileName(FStartDir, Data.ULM.MethodFileName);}
  end;
  {/v0.14}
end;

{v0.14}
constructor TAnalSetupForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  {v0.25}{/v0.25
  Data := TAcqData(Obj.MainUser);}
end;
{/v0.14}

procedure TAnalSetupForm.FormActivate(Sender: TObject);
begin
  inherited;
  ParametersBtn.Visible := UserMode = umSysOp;
  {v0.15}
  if Data.ULI.IsFlagSet(rfWriteLocked) then begin
    InstrumentLoadFromBtn.Enabled := false;
  end;
  {/v0.15}
  {v0.53}
  if fsModal in FormState then
    Modified := false;
  {/v0.53}
end;

procedure TAnalSetupForm.ParametersBtnClick(Sender: TObject);
begin
  inherited;
  Obj.Browse;
end;

{v0.14}
procedure TAnalSetupForm.CalibrationFileBtnClick(Sender: TObject);
var fn:string;
begin
  inherited;
  fn := Data.ULM.CalibrationFileName;
  if fn <> '' then
    CalibrationFileSelectDialog.FileName := fn;
  {v0.62}
  CalibrationFileSelectDialog.Filter := CalibrationFileDialogFilter;
  {/v0.62}
  if CalibrationFileSelectDialog.Execute then begin
    Data.CalibrationFileSelect(CalibrationFileSelectDialog.FileName);
    ULObjToForm(Data.ULM, Self, [foOnlyFileNames], FObjRootFileDir);
    {v0.30 moved to TAcqData.CalibrationFileSelect }{/v0.30
    if Data.Spectrum = nil then
      exit;
    Data.Spectrum.PeaksAmountsCalculateCalibrationFile;}
  end;
end;
{/v0.14}

procedure TAnalSetupForm.InstrumentLoadFromBtnClick(Sender: TObject);
var s:string;
begin
  inherited;
  {v0.14}
  GetDir(0, s);
  InstrumentOpenDialog.InitialDir := s;
  if Data.ULI.InstrumentTemplate <> '' then
    InstrumentOpenDialog.FileName := Data.ULI.InstrumentTemplate;
  if InstrumentOpenDialog.Execute then begin
    Data.InstrumentLoadFromFile(InstrumentOpenDialog.FileName);
    ULObjToForm(Data.ULI, Self, {v0.15}[]{/v0.15 [foOnlyFileNames]}, FObjRootFileDir);
{    InstrumentTemplateEdit.Text := RelativeFileName(FStartDir, Data.ULI.InstrumentTemplate);}
  end;
  {/v0.14}
end;

procedure TAnalSetupForm.InstrumentSaveToBtnClick(Sender: TObject);
var s: string;
begin
  inherited;
  {v0.14}
  GetDir(0, s);
  InstrumentSaveDialog.InitialDir := s;
  if Data.ULI.InstrumentFileName <>  '' then
    InstrumentSaveDialog.FileName := Data.ULI.InstrumentFileName;
  if InstrumentSaveDialog.Execute then begin
    Data.InstrumentSaveToFile(InstrumentSaveDialog.FileName);
    ULObjToForm(Data.ULI, Self, [foOnlyFileNames], FObjRootFileDir);
  end;
  {/v0.14}
end;

{v0.25}
procedure TAnalSetupForm.Loaded;
begin
  inherited;
  FormStyle := fsNormal;
  Visible := false;
  {v0.53}
  Modified := false;
  {/v0.53}
end;
{/v0.25}

procedure TAnalSetupForm.FormCreate(Sender: TObject);
begin
  {v0.53}
  inherited;
  {/v0.53}
  PageControl.ActivePage := ULATabSheet;
  {v0.53}
  Modified := false;
  {/v0.53}
end;

procedure TAnalSetupForm.DataLinesButtonClick(Sender: TObject);
begin
  {v0.53}
  if CheckApply then
  {/v0.53}
  begin
    Data.ULI_UDLS.Browse;
    {v0.53}
    Modified := false;
    {/v0.53}
  end;
end;

procedure TAnalSetupForm.Button1Click(Sender: TObject);
begin
  {v0.53}
  if CheckApply then
  {/v0.53}
  begin
  Data.Prg.Obj.Browse;
  {Data.ULI_USP.Browse;}
    {v0.53}
    Modified := false;
    {/v0.53}
  end;
end;

{v0.53}
function TAnalSetupForm.CheckApply: boolean;
begin
  Result := false;
  if Modified then begin
    case ShowMessage(GetTxt('Apply current setup changes') + '?', smYesNoCancel, 0) of
      cmYes: begin
        if not DoApply then
          exit;
      end;
      cmNo:;
    else
      exit;
    end;
  end;
  Result := true;
end;

function TAnalSetupForm.DoApply: boolean;
begin
  Result := false;
  if FileNameEdit.Visible then begin
    FFileName := FileNameEdit.Text;
    if trim(FFileName) <> '' then begin
      FFileName := ChangeFileExt(DataDir + ExtractFileName(FileNameEdit.Text), ULFExt);
      if FileExists(FFileName) then begin
        if ShowMessage(GetTxt({#}'File') + ' ' + FFileName + ' ' + GetTxt({#}'Exists. Overwrite?'), smNoYes, 0) <> cmYes then begin
          ModalResult := 0;
          PageControl.ActivePage := ULATabSheet;
          FileNameEdit.SetFocus;
          exit;
        end;
      end;
      Data.ULF.FileName := FFileName;
    end;
  end;
  ComponentsToObj;
  Modified := false;
  Result := true;
end;

procedure TAnalSetupForm.ApplyBtnClick(Sender: TObject);
begin
  DoApply;
end;

procedure TAnalSetupForm.SetModified(OnOff: boolean);
begin
  inherited;
  if FIsInModify then
    exit;
  FIsInModify := true;
  try
    ApplyBtn.Enabled := OnOff;
  finally
    FIsInModify := false;
  end;
end;
{/v0.53}

end.
