unit ULCType;{ Format of ULC = calibration related data root
 source for MakeComp program }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  UlanType, ULRecTyp;
const
  ULCID = ord('U') + 256* ord('L') + 256 * 256 * ord('C');


type
  TULCRec = packed record {<Caption="Calibration" RootChild=1
     ChildRecIDs=UCPID,UCFID HasRecName=1
     Uses=UCPType,UCFType
     OpenFilter="Calibration file (*.ULC)|*.ULC"
     SaveFilter="Calibration file (*.ULC)|*.ULC"
     AskForSave=1 Enabled=1 Visible=1>}
    Head: TULRecHead;
    Info: TULRecInfo;
    CalibName:TSampleName;{<Enabled=1 Caption="Calib. Name">}
      { Name of the calibration data. }
    CalibDesc:TSampleDesc;{<Enabled=1 Caption="Calib. Desc.">}
      { Longer description of the calibration }
    UserID:TUserID;{<Enabled=1>}
      { User id of the analyst. }
    UserName:TUserName;{<Enabled=1>}
      { Short name of the analyst (copy from ulu file, for the case the UserID
        record will be deleted from ulu file). }
    DateTime: longint;{<Caption="Date,Time" Hint="Date/Time when was the acquisition finished"
      Type=FileDateTime Enabled=1>}
      { Introduced in version 0.28 }
    CalibType: TCalibType;
    PeakFindKind: TPeakFindKind;{<Hint="Composed peaks created either from each peak in any file (OR) or only from peaks found in each file (AND)">}
  end;
  PULCRec = ^TULCRec;

implementation

end.
