unit ULIType;
{ Description of .ULI  instrument file records formats
  All information necessary for acquiring data - can not be modified
  after acquisition completed.
}
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses
  UlanType, ULRecTyp;{ULANRECS.LST}

const
  ULIExt = '.ULI';
    { Instrument file extension }
  ULIID = ord('U') + 256*ord('L') + 256*256*ord('I');
    { ID of instrument record }
{ulltype usptype aapgtype}
type

  TULIRec = packed record {<Caption="Instrument" ChildRecIDs=USPID,AAPGID,UDLSID
    RootChild=1 Uses=USPType,AAPGType,ULLType,UDLSType Enabled=1 Visible=1
    Create1="DataWaitTimeout := DefDataWaitTimeout;">}
    Head: TULRecHead;
      { Head.RecID set to UliID, Head.RecLen = sizeof(TUliRec) }
    Info: TULRecInfo;
    InstrumentTemplate: TULFileName;{<Enabled=1 ReadOnly=1 Type=FileName>}
      { what file was used as the template for creation of this file
        ( = '' if none) }
    Column: TColumnName;{<Enabled=1>}
      { description of the column used for separation }
    MobilePhase: TMobilePhase;{<Enabled=1>}
      { description of the mobile phase used for separation }
    FlowRate: TFlowRate;{<Enabled=1>}
      { what flow rate was used for the separation (if no gradient used),
        or starting flow rate (if gradient used) }
    FlowRateUnit: TFlowRateUnit;{<Type=Enum Enabled=1 StripPrefix=fu>}
      { What units are used for FlowRate values. }
    Detection: TDetection;{<Enabled=1>}
      { description of detection method used }
    Temperature: TTemperature;{<Enabled=1>}
      { what was the temperature during the measurement }
    TemperatureUnit: TTemperatureUnit;{<Type=Enum Enabled=1 StripPrefix=tu>}
      { what unit is used for Temperature values }
    InstrumentFileName: TULFileName;{<Enabled=1 Type=FileName ReadOnly=1>}
      { To what file was the instrument object info saved
        (if any, makes sense if instrument was loaded from Instrument template
         and was modified or was created from the scratch) }
    {v0.14}
    ChannelName: TChannelName;{<Enabled=1 Type=ULEnum ValuesSourceRecID=ULLID>}
    {/v0.14}
    {v0.15}
    Duration: single;{<Enabled=1 UserCoef=60 NumDec=2
      Caption="Duration of Analysis [min]">}
      { If non zero, then after this time the acquisition
        will autostop }
    SamplingInterval: single;{<Enabled=1 Caption="Sampling interval [s]">}
      { If non  zero, then defines other then default interval for taking
        epxerimental values from the device }
    {/v0.15}
    {v0.21}
    DataWaitTimeout: single;{<Enabled=1 Caption="How long wait for data [s]">}
      { If no data are comming from the port for longer time than specified
        here, acquisition will be suspended and error reported. Default
        value = 5 s (used also if 0 specified). }
    {/v0.21}
    {v0.50}
    IdleTime: single;{<Enabled=1 Caption="Sample Idle Time[s]"
      Hint="Interval between sequence samples (end of the first, start of the second)">}
      { Interval between sequence samples (end of first - start of second)
        in seconds }
    FileMask: string;{<Enabled=1 Caption="Sample File Mask" DefVal="'Sample*'">}
      { How should look file names for acquired sequence sample data of each run.
        E.g. "Sample*" will generate names Sample1, Sample2, ... . }{ulrectyp}
    StoreScripts: boolean;{<Enabled=1 Caption="Store used scripts?"
      Hint="Store source code of all scrits used during acquisition?">}
    Scripts: string;{<Caption="Scripts" Type=Memo>}
      { Full source codes of scripts used during acquisition
       (if StoreScripts is true). Each script file section starts
       with "=== ScriptName" line and is folowed by the source code lines. }
    SequenceKind: TSequenceKind;{<Caption="Sequence Kind" StripPrefix=sk Type=Enum>}
      { Specifies if the sequence (if any) was generated by Amino Acid Analyser
        application (old style) or for standalone - channel device set
        (new style) }
    {/v0.50}
  end;
  PULIRec = ^TULIRec;

implementation

end.
