{
  ------------------------------------------------------------------------------
    Filename: CEFormRegister.pas
    Version:  v1.0
    Authors:  Michael Drig (md)
    Purpose:  Design time suppor for CEForm
    Remark:   Needs TXStringGrid v1.2
  ------------------------------------------------------------------------------
    (C) 1999  M. Drig
              CH-4056 Basel
              mduerig@eye.ch / www.eye.ch/~mduerig
  ------------------------------------------------------------------------------
    History:  12.08.99md  v1.0 Creation
  ------------------------------------------------------------------------------
}
unit CEFormRegister;

interface
uses Classes
  {$IFDEF DESIGNINT}
  , dsgnintf{, Exptintf}
  {$ENDIF}
  ;

{$IFDEF DESIGNINT}
type
  TFormClassEditorProperty = class(TStringProperty)
  private
    cbEnumForm: TGetStrProc;
  public
    procedure GetValues(Proc: TGetStrProc); override;
    function GetAttributes: TPropertyAttributes; override;
  end;
{$ENDIF}
  procedure Register;

implementation
uses CEForm;

procedure Register;
begin
  RegisterComponents('XStringGrid', [TFormCellEditor]);
  {$IFDEF DESIGNINT}
  RegisterPropertyEditor(TypeInfo(TFormInplaceName), TFormCellEditor, '', TFormClassEditorProperty);
  {$ENDIF}
end;

{$IFDEF DESIGNINT}
function TFormClassEditorProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paValueList];
end;

function cbEnumProjectUnits(Param: Pointer; const FileName, UnitName, FormName: string): Boolean stdcall;
begin
  if FormName <> '' then
    TFormClassEditorProperty(Param).cbEnumForm('T' + FormName);

  result := true;
end;

procedure TFormClassEditorProperty.GetValues(Proc: TGetStrProc);
begin
  cbEnumForm := Proc;
  {ToolServices.EnumProjectUnits(cbEnumProjectUnits, self);}
end;
{$ENDIF}

end.
