unit ListType;

interface
const
{ltXXXX list types:}
  ltTypeMask = $FFFF;
  ltOptionsMask = $FFFF0000;
  {low two bytes identify type of objects,
   high two bytes options:}
  ltPointers = 0;
  {just list of pointers, nothing more; items
   are not disposed or anything else automatically}
  ltStrings = 1;
  {list of PString pointers (DisposeStr used for autodestroy)}
  ltLongints = 2;
  { list of longint numbers }
  ltRecords = 3;
  { list of memory records (FreeMem method used for autodestroy) }
  ltObjects = 4;
  { list of TObject descendants (ClassFree method used for autodestroy)}

  ltAutoDestroy = $10000;
  {if known size of items, then every item
   will be disposed upon Delete or Remove }
  ltAutoSort = $20000;
  {if known type of items, then every add will
   perform sort (ascending)}
  ltSortDescending = $40000;
  {if known type and ltAutoSort set, then every
    add will perform sort, but in descending order}
  ltAutoPack = $80000;

{lpXXXX list properties:}
  lpCount = 0;
  {number of added items}
  lpCapacity = 1;
  {number of all slots available for add}

  NoListInfo = nil;
type
  TListType = longint;
  TListProperty = integer;
  TListSortCmp = function (Item1, Item2: Pointer): Integer;
  TLst = pointer;

  PListInfo = ^TListInfo;
  TListInfo = record
    RecordSize:longint;
    ListSortCmp:TListSortCmp;
    Capacity:longint;
  end;

implementation

end.
