unit SelectDateTimeFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Language;

type
  TSelectDateTimeForm = class(TForm)
    DateTimePicker1: TDateTimePicker;
    OKButton: TButton;
    DateTimeLabel1: TLabel;
    DateTimePicker2: TDateTimePicker;
    CancelButton: TButton;
    DateTimeLabel2: TLabel;
    TimePicker1: TDateTimePicker;
    TimePicker2: TDateTimePicker;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SelectDateTimeForm: TSelectDateTimeForm;

function SelectMonth(const ATitle: string; var ADateTime: TDateTime): boolean;
{v0.50}
function SelectDateTimePeriod(const ATitle: string; var ADateTime1: TDateTime;
  var ADateTime2: TDateTime): boolean;
{/v0.50}
implementation

{$R *.DFM}

function SelectMonth(const ATitle: string; var ADateTime: TDateTime): boolean;
var f: TSelectDateTimeForm;
begin
  Result := false;
  f := TSelectDateTimeForm.Create(nil);
  try
    if ATitle <> '' then
      f.Caption := ATitle
    else
      f.Caption := GetTxt({#}'Select month');
    f.DateTimeLabel2.Visible := false;
    f.DateTimePicker2.Visible := false;
    {v0.50}
    f.TimePicker1.Visible := false;
    f.TimePicker2.Visible := false;
    f.DateTimePicker1.DateTime := ADateTime;
    f.DateTimePicker1.Kind := dtkDate;
    f.DateTimeLabel1.Caption := GetTxt({#}'Month');
    {v0.60}
    f.CancelButton.Caption := GetTxt({#}'&Cancel');
    {/v0.60}
    if f.ShowModal = mrOK then begin
      ADateTime := f.DateTimePicker1.DateTime;
      Result := true;
    end;
  finally
    f.Free;
  end;
end;


{v0.50}
function SelectDateTimePeriod(const ATitle: string; var ADateTime1: TDateTime;
  var ADateTime2: TDateTime): boolean;
var f: TSelectDateTimeForm;
begin
  Result := false;
  f := TSelectDateTimeForm.Create(nil);
  try
    if ATitle <> '' then
      f.Caption := ATitle
    else
      f.Caption := GetTxt({#}'Select date/time period');
    f.DateTimePicker1.Date := ADateTime1;
    f.TimePicker1.Time := ADateTime1;
    f.DateTimeLabel1.Caption := GetTxt({#}'From Date/Time');

    f.DateTimePicker2.Date := ADateTime2;
    f.TimePicker2.Time := ADateTime2;
    f.DateTimeLabel2.Caption := GetTxt({#}'To Date/Time');
    {v0.60}
    f.CancelButton.Caption := GetTxt({#}'&Cancel');
    {/v0.60}

    if f.ShowModal = mrOK then begin
      ADateTime1 := trunc(f.DateTimePicker1.Date) + frac(f.TimePicker1.Time);
      ADateTime2 := trunc(f.DateTimePicker2.Date) + frac(f.TimePicker2.Time);
      Result := true;
    end;
  finally
    f.Free;
  end;
end;
{/v0.50}

end.
