program h2pas;{converts C constatns file to pascal constats file }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

uses dos,crt,mylib;

procedure Convert(InFile, OutFile:PathStr);
var
  s,valu:string;
  p:byte;
  fin,fout:text;
  d:dirstr;
  n:namestr;
  e:extstr;
begin
  InFile := ReplaceExt(InFile, '.H', false);
  if OutFile = '' then
    OutFile := ReplaceExt(InFile, '.PAS', true)
  else
    OutFile := ReplaceExt(InFile, '.PAS', false);
  assign(fin, InFile);
  reset(fin);
  assign(fout, OutFile);
  rewrite(fout);
  FSplit(OutFile, d, n, e);
  writeln(fout,'unit ' + n + ';');
  writeln(fout,'interface');
  writeln(fout,'const');

{  writeln(}
  while not eof(fin) do begin
    readln(fin, s);
    p := pos('#', s);
    if p > 0 then begin
      p := pos(' ',s);
      if p = 0 then
        p := pos(#9,s);
      s := trim(copy(s, p, 255));{split off #define}
      p := pos(' ',s);
      if p = 0 then
        p := pos(#9,s);
      valu := trim(copy(s, succ(p),255));
{      dec(valu[0]);{remove ';'}
      s := trim(copy(s,1,pred(p)));
      writeln(fout, '  ', s, ' = ', valu,';');
    end;
  end;
  writeln(fout,'implementation');
  writeln(fout,'end.');
  close(fin);
  close(fout);
end;

begin
  if paramcount = 0 then begin
    writeln('Usage: H2PAS file1[.H] [file2[.PAS]]');
    writeln(' Converts C constats file to PAS constats file.');
  end else begin
    convert(paramstr(1), paramstr(2));
  end;
end.

