unit BaseLineu;{v0.50}
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, Baseline developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface
uses Classes, ULRecTyp, ULRecUtl, ULObju, ULObjUsru,
  ULBType, ULBObju,
  ULBRType, ULBRObju;

type
  TBaseline = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetULB: TULBObj;
    function ChildCreate(AChildObj: TULObj): TULObjUsr; override;
  public
    property ULB: TULBObj read GetULB;
  end;


  TBaselineRecord = class(TULObjUsr)
  protected
    function GetRecID: TULRecID; override;
    function GetULBR: TULBRObj;
    function ChildCreate(AChildObj: TULObj): TULObjUsr; override;
  public
    property ULBR: TULBRObj read GetULBR;
  end;

implementation

function TBaseline.GetULB: TULBObj;
begin
  Result := TULBObj(Obj);
end;

function TBaseline.ChildCreate(AChildObj: TULObj): TULObjUsr;
var
  id:TULRecID;
  blr: TBaseLineRecord;
begin
  Result := nil;
  if AChildObj = nil then begin
    id := ULBRID
  end else begin
    id := AChildObj.RecID;
  end;
  case id of
    ULBRID: begin
      blr := TBaseLineRecord.Create(Self, AChildObj, id);
      Result := TULObjUsr(blr);
    end;
  else
    SetResult(urUnknownChildRecID, ULRecIDToStrStrip(id));{ulrecutl}
  end;
end;

function TBaseline.GetRecID: TULRecID;
begin
  Result := ULBID;
end;

{TBaselineRecord.}
function TBaselineRecord.GetULBR: TULBRObj;
begin
  Result := TULBRObj(Obj);
end;

function TBaselineRecord.ChildCreate(AChildObj: TULObj): TULObjUsr;
begin
  Result := nil;
end;

function TBaselineRecord.GetRecID: TULRecID;
begin
  Result := ULBRID;
end;
{/TBaselineRecord.}

{v0.24}
initialization
  RegisterClasses([TBaseline]);
{/v0.24}
end.
