unit alprevfr;{upreview;}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, AlRep, AlPrev;

type
  TfrmPreview = class(TForm)
    ToolPanel    : TPanel;
    btnPrintNow  : TSpeedButton;
    cbxScale     : TComboBox;
    Label1       : TLabel;
    btnClose     : TButton;
    spbfirst     : TSpeedButton;
    spbPrev      : TSpeedButton;
    spbNext      : TSpeedButton;
    spbLast      : TSpeedButton;
    PrintDialog1 : TPrintDialog;
    Previewer    : TAlPreview;   // tScrollBox
    Panel1       : TPanel;
    procedure btnCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure spbfirstClick(Sender: TObject);
    procedure spbPrevClick(Sender: TObject);
    procedure spbNextClick(Sender: TObject);
    procedure spbLastClick(Sender: TObject);
    procedure cbxScaleChange(Sender: TObject);
    procedure btnPrintNowClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure FirstPage;
  end;

var
  frmPreview: TfrmPreview;

procedure PreviewPages(APages: TPages);

implementation

{$R *.DFM}

procedure TfrmPreview.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmPreview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  frmPreview := NIL;
end;

procedure TfrmPreview.spbfirstClick(Sender: TObject);
begin
  Previewer.FirstPage;
  Panel1.Caption := IntToStr(Previewer.PageNumber)+'/'+
                    IntToStr(Previewer.PageCount);
end;

procedure TfrmPreview.spbPrevClick(Sender: TObject);
begin
  Previewer.PrevPage;
  Panel1.Caption := IntToStr(Previewer.PageNumber)+'/'+
                    IntToStr(Previewer.PageCount);
end;

procedure TfrmPreview.spbNextClick(Sender: TObject);
begin
  Previewer.NextPage;
  Panel1.Caption := IntToStr(Previewer.PageNumber)+'/'+
                    IntToStr(Previewer.PageCount);
end;

procedure TfrmPreview.spbLastClick(Sender: TObject);
begin
  Previewer.LastPage;
  Panel1.Caption := IntToStr(Previewer.PageNumber)+'/'+
                    IntToStr(Previewer.PageCount);
end;

procedure TfrmPreview.cbxScaleChange(Sender: TObject);
begin
  Previewer.Zoom := StrToIntDef (cbxScale.Text,100);
end;

procedure tFrmPreview.FirstPage;
begin
  spbFirstClick(Self);
end;

procedure TfrmPreview.btnPrintNowClick(Sender: TObject);
var
  i : integer;
begin
  PrintDialog1.Options  := [poPageNums];
  PrintDialog1.MinPage  := 1;
  PrintDialog1.MaxPage  := Previewer.PageCount;
  PrintDialog1.FromPage := 1;
  PrintDialog1.ToPage   := Previewer.PageCount;
  if PrintDialog1.Execute then
  begin
    Previewer.Title := Caption;
    for i:=1 to PrintDialog1.Copies do
       Previewer.Print(PrintDialog1.FromPage,PrintDialog1.ToPage);
  end;
end;

procedure TfrmPreview.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := NOT Previewer.Busy;
  if NOT CanClose then
     MessageBeep (MB_ICONEXCLAMATION);
end;

procedure TfrmPreview.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case key of
    vk_escape : Close;
    vk_Prior  : spbPrevClick(Self);
    vk_Next   : spbNextClick(Self);
    vk_Home   : spbFirstClick(Self);
    vk_End    : spbLastClick(Self);

    vk_Up     : with Previewer do
                 begin
                   if VertScrollBar.Position>10 then
                      VertScrollBar.Position := VertScrollBar.Position-10
                   else
                      VertScrollBar.Position := 0;
                 end;
    vk_Down   : with Previewer do
                 begin
                   if VertScrollBar.Position<VertScrollBar.Range-10 then
                      VertScrollBar.Position := VertScrollBar.Position+10
                   else
                      VertScrollBar.Position := VertScrollBar.Range;
                 end;
    vk_Left   : with Previewer do
                 begin
                   if HorzScrollBar.Position>10 then
                      HorzScrollBar.Position := HorzScrollBar.Position-10
                   else
                      HorzScrollBar.Position := 0;
                 end;
    vk_Right  : with Previewer do
                 begin
                   if HorzScrollBar.Position<HorzScrollBar.Range-10 then
                      HorzScrollBar.Position := HorzScrollBar.Position+10
                   else
                      HorzScrollBar.Position := HorzScrollBar.Range;
                 end;

    else exit;
  end;
  key := 0;
end;

procedure PreviewPages(APages: TPages);
begin
  with TFrmPreview.Create(Application) do
  begin
    Previewer.Pages := APages;
    FirstPage;
  end;
end;

end.
