{Author:	Poul Bak}
{Copyright  1999 : BakSoft-Denmark (Poul Bak). All rights reserved.}
{http://home11.inet.tele.dk/BakSoft/}
{Mailto: baksoft-denmark@dk2net.dk}

{Component Version: 2.00.00.00}
{PBSystemPath gives easy access to systempaths, see Shellfolders.txt to see why
you shall use PBSystemPath.}
{A tip: In your code, check if the property is empty (=''). As you can see in
Shellfolders.txt not all paths are supported by all windows-versions.} 
unit PBSystem;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	Registry;

type
	TPBSystemPath = class(TComponent)
	private
		{ Private declarations }
		FAppData, FCache, FCookies, FDeskTop, FFavorites : string;
		FFonts, FHistory, FNetHood, FPersonal, FPrintHood : string;
		FPrograms, FRecent, FSendTo, FStartMenu, FStartUp : string;
		FTemplates, FWindows, FSystem, FTemp : string;
		FCommonFiles, FConfig, FDevice, FMedia, FOtherDevice : string;
		FProgramFiles, FSystemRoot, FWallPaper : string;
		FVersion, FMyPictures, FLocalSettings, FLocalAppData, FContent : string;
		procedure Dummy(Value: String);
	protected
		{ Protected declarations }
	public
		{ Public declarations }
		constructor Create(AOwner: TComponent); override;
	published
		{ Published declarations }
		property AppData : string read FAppData write Dummy;
		property Cache : string read FCache write Dummy;
		property Cookies : string read FCookies write Dummy;
		property DeskTop : string read FDeskTop write Dummy;
		property Favorites : string read FFavorites write Dummy;
		property Fonts : string read FFonts write Dummy;
		property History : string read FHistory write Dummy;
		property NetHood : string read FNetHood write Dummy;
		property Personal : string read FPersonal write Dummy;
		property PrintHood : string read FPrintHood write Dummy;
		property Programs : string read FPrograms write Dummy;
		property Recent : string read FRecent write Dummy;
		property SendTo : string read FSendTo write Dummy;
		property StartMenu : string read FStartMenu write Dummy;
		property StartUp : string read FStartUp write Dummy;
		property Templates : string read FTemplates write Dummy;
		property Windows : string read FWindows write Dummy;
		property System : string read FSystem write Dummy;
		property Temp : string read FTemp write Dummy;
		property CommonFiles : string read FCommonFiles write Dummy;
		property Config : string read FConfig write Dummy;
		property Device : string read FDevice write Dummy;
		property Media : string read FMedia write Dummy;
		property OtherDevice : string read FOtherDevice write Dummy;
		property ProgramFiles : string read FProgramFiles write Dummy;
		property SystemRoot : string read FSystemRoot write Dummy;
		property WallPaper : string read FWallPaper write Dummy;
		property ComponentVersion : string read FVersion write Dummy;
		property MyPictures : string read FMyPictures write Dummy;
		property LocalSettings : string read FLocalSettings write Dummy;
		property LocalAppData : string read FLocalAppData write Dummy;
		property Content : string read FContent write Dummy;
	end;

procedure Register;

implementation

constructor TPBSystemPath.Create(AOwner: TComponent);
var
	PText : array[0..255] of Char;
	laengde : integer;
	Reg : TRegistry;
begin
	inherited Create(AOwner);
	laengde := GetWindowsDirectory(PText, MAX_PATH);
	FWindows := copy(PText, 1, laengde);
	laengde := GetSystemDirectory(PText, MAX_PATH);
	FSystem := copy(PText, 1, laengde);
	laengde := GetTempPath(MAX_PATH, PText);
	FTemp := copy(PText, 1, laengde);
	Reg := TRegistry.Create;
	if Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders', False) then
	begin
		FAppData := Reg.ReadString('AppData');
		FCache := Reg.ReadString('Cache');
		FCookies := Reg.ReadString('Cookies');
		FDeskTop := Reg.ReadString('DeskTop');
		FFavorites := Reg.ReadString('Favorites');
		FFonts := Reg.ReadString('Fonts');
		FHistory := Reg.ReadString('History');
		FNetHood := Reg.ReadString('NetHood');
		FPersonal := Reg.ReadString('Personal');
		FPrintHood := Reg.ReadString('PrintHood');
		FPrograms := Reg.ReadString('Programs');
		FRecent := Reg.ReadString('Recent');
		FSendTo := Reg.ReadString('SendTo');
		FStartMenu := Reg.ReadString('Start Menu');
		FStartUp := Reg.ReadString('StartUp');
		FTemplates := Reg.ReadString('Templates');
		FMyPictures := Reg.ReadString('My Pictures');
		FLocalSettings := Reg.ReadString('Local Settings');
		FLocalAppData := Reg.ReadString('Local AppData');
		FContent := Reg.ReadString('Content');
	end;
	Reg.RootKey := HKEY_LOCAL_MACHINE;
	if Reg.OpenKey('Software\Microsoft\Windows\CurrentVersion', False) then
	begin
		FCommonFiles := Reg.ReadString('CommonFilesDir');
		FConfig := Reg.ReadString('ConfigPath');
		FDevice := Reg.ReadString('DevicePath');
		FMedia := Reg.ReadString('MediaPath');
		FOtherDevice := Reg.ReadString('OtherDevicePath');
		FProgramFiles := Reg.ReadString('ProgramFilesPath');
		FSystemRoot := Reg.ReadString('SystemRoot');
		FWallPaper := Reg.ReadString('WallPaperDir');
	end;
	Reg.Free;
	FVersion := '2.00.00.00';
end;

procedure TPBSystemPath.Dummy(Value: String);
begin
//	Read only !
end;

procedure Register;
begin
	RegisterComponents('NonVis', [TPBSystemPath]);
end;

end.

