unit CalibrationFrm;{v0.64}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
  UlanType, ULRecTyp, ULObju,ULObjEditPanelu, Grids, XStringGrid,
  ULStringGrid, LsFileExplorer26, ComCtrls, Spectrum, CalDatau,

  UCPType, UCPObju, UCFType, UCFObju, UCFRType, UCFRObju
  {v0.65}
  ,UCPLType, UCPLObju, ExtComDl //todo.txt ulfobju
  {/v0.65}
  {v0.67}
  ,UlanGlob
  {/v0.67}
  ;

type
  TCalibrationForm = class(TForm)
    CalibrationTypeRadioGroup: TRadioGroup;
    SaveButton: TButton;
    FileNameEdit: TEdit;
    Label1: TLabel;
    FilesGrid: TULStringGrid;
    PeaksGrid: TULStringGrid;
    PeakLevelsGrid: TULStringGrid;
    PeaksHeadEditPanel: TULObjEditPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    AddBtn: TButton;
    DelBtn: TButton;
    DirTreeCombo: TLsDirTreeCombo26;
    FileListView: TLsFileListView26;
    ComposePeaksBtn: TButton;
    CreatePeakLevelBtn: TButton;
    ESaveDialog: TESaveDialog;
    SelectFileNameBtn: TButton;
    procedure SaveButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure FileNameEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DelBtnClick(Sender: TObject);
    procedure ComposePeaksBtnClick(Sender: TObject);
    procedure PeaksGridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure CreatePeakLevelBtnClick(Sender: TObject);
    procedure SelectFileNameBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    FCalData: TCalData;
    FInitialDir: string;
    function GetCalData: TCalData;
    function GetCalDataName: string;
    procedure UpdateControls;
    procedure SetCalData(ACalData: TCalData);
    procedure SetCalDataName(const AFileName: string);
    procedure CheckCalData;
    {v0.67}
    procedure SetInitialDir(const ADir: string);
    {/v0.67}
  public
    { Public declarations }
    property CalData: TCalData read GetCalData write SetCalData;
    property CalDataName: string read GetCalDataName write SetCalDataName;
    {v0.67}
    property InitialDir: string read FInitialDir write SetInitialDir;
    {/v0.67}
  end;

const
  CalibrationForm: TCalibrationForm = nil;

function ComposeCalibrationFormExecute(const ADirName: string;
  {/v0.65}AFileList: TStringList;
  {/v0.65} {v0.67}const {/v0.67 var} AFileName: string;
  {v0.67}{/v0.67 var} CalibrationType: TCalibType): boolean;

{v0.67}
function CalibrationFormOpen(const AFileName: string;
  AMode: TOpenMode): TCalibrationForm;
{/v0.67}

implementation

{$R *.DFM}

function ComposeCalibrationFormExecute(const ADirName: string;
  {/v0.65}AFileList: TStringList; {/v0.65}
  {v0.67}const {/v0.67 var }AFileName: string;
  {v0.67}{/v0.67 var} CalibrationType: TCalibType): boolean;
var
  ucfr: TUCFRObj;
  i: integer;
  {v0.67}
  cf: TCalibrationForm;
  {/v0.67}
begin
  cf := nil;
  if cf = nil then
    cf := TCalibrationForm.Create(Application);
  {v0.67}
  Result := false;
  try
  {/v0.67}
    cf.CalibrationTypeRadioGroup.ItemIndex := ord(CalibrationType);
    {v0.67}
    cf.CalDataName := AFileName;
    cf.InitialDir := ADirName;
    {/v0.67
    cf.FileNameEdit.Text := AFileName;
    cf.DirTreeCombo.OpenPath(ADirName);
    cf.FileListView.Directory := ADirName;
    cf.ESaveDialog.InitialDir := ADirName;}
    {v0.65}
    if (AFileList <> nil) and (AFileList.Count > 0) then begin
      for i := 0 to AFileList.Count - 1 do begin
        ucfr := TUCFRObj(cf.CalData.ULC_UCF.Add(UCFRID));
        ucfr.FileName := AFileList[i];
      end;
    end;
    {/v0.65}
    {v0.67}
    cf.Show;
    Result := true;
    {/v0.67
    if cf.ShowModal = mrOK then begin

      CalibrationType := TCalibType(cf.CalibrationTypeRadioGroup.ItemIndex);
      AFileName := cf.FileNameEdit.Text;
      Result := true;
    end else begin
      Result := false;
    end;
    {/v0.67}
  {v0.67}
  except
    cf.Free;
  end;
  {/v0.67}
end;

{v0.67}
procedure TCalibrationForm.SetInitialDir(const ADir: string);
begin
  if ADir = '' then
    exit;
//    cf.FileNameEdit.Text := AFileName;
  FInitialDir := ADir;
  DirTreeCombo.OpenPath(ADir);
  FileListView.Directory := ADir;
  ESaveDialog.InitialDir := ADir;
end;

function TCalibrationForm.GetCalDataName: string;
begin
  {v0.67}
  if CalData = nil then
    Result := ''
  else
  {/v0.67}
    Result := CalData.FileName;
end;

{/v0.67}
procedure TCalibrationForm.CheckCalData;
begin
  if FCalData = nil then begin
    FCalData := TCalData.Create('', omCreate);
    UpdateControls;
  end;
end;
{/v0.67}

procedure TCalibrationForm.SetCalDataName(const AFileName: string);
begin
  {v0.67}
  CheckCalData;
  {/v0.67}
  if FileExists(AFileName) and (AFileName <> CalData.FileName) then begin
    CalData.SetFileName(AFileName, omRead);
  end else begin
    CalData.ChangeFileName(AFileName);
  end;
  {v0.67}
  InitialDir := ExtractFileDir(AFileName);
  UpdateControls;
  {/v0.67}
end;

function TCalibrationForm.GetCalData: TCalData;
begin
  if FCalData = nil then begin
    {v0.67}{/v0.67 FCalData := TCalData.Create(FileNameEdit.Text, omRead);}

    //CreateOrOpenDataFile(CalDataName, FCalData);//: boolean;
    //if CalDataName = '' then
    //  FCalData.ULF.FileName := 'NONAME.CAL';
  end;
  Result := FCalData;
end;

procedure TCalibrationForm.SetCalData(ACalData: TCalData);
begin
  if FCalData = ACalData then
    exit;
  if FCalData <> nil then
    FCalData.Free;
  FCalData := ACalData;
  UpdateControls;
end;

procedure TCalibrationForm.SaveButtonClick(Sender: TObject);
begin
  {v0.67}
  CalData.DoFileSave;
  UpdateControls;
  {/v0.67
  if FileNameEdit.Text = '' then begin
    ShowMessage('Enter name for the composed calibration file');
    ModalResult := 0;
    exit;
  end;
  CalData.Save;
  }
end;                                 // ulobju filescanner   filedropper


procedure TCalibrationForm.FormActivate(Sender: TObject);
begin
  {v0.65}
  UpdateControls;
 {/v0.65
  FilesGrid.Obj := CalData.ULC_UCF;
}
end;

{v.65}
procedure TCalibrationForm.UpdateControls;
begin
  {v0.67}
  if FCalData = nil then begin
    FilesGrid.Obj := nil;
    PeaksGrid.Obj := nil;
    PeakLevelsGrid.Obj := nil;
    FileNameEdit.Text := '';
    SaveButton.Enabled := false;
  end else
  {/v0.67}
  begin
    FilesGrid.Obj := CalData.ULC_UCF;
    PeaksGrid.Obj := CalData.ULC_UCP;
    PeakLevelsGrid.Obj := nil;
    {v0.67}
    FileNameEdit.Text := CalData.FileName;
    SaveButton.Enabled := true;//CalData.ULF.Modified;
    {/v0.67}
  end;
end;
{v0.65}

procedure TCalibrationForm.AddBtnClick(Sender: TObject);
var
  f: TUCFRObj;
  v: TListItem;
begin
//tlistview
  v := FileListView.Selected;
  while v <> nil do begin
    {v0.67}
    CheckCalData;
    {/v0.67}
    f := TUCFRObj(FilesGrid.Obj.Add(UCFRID));
    f.FileName := v.Caption;//FileListView.SelectedItem;
    v := FileListView.GetNextItem(v, sdAll, [isSelected]);
  end;
end;

procedure TCalibrationForm.FileNameEditChange(Sender: TObject);
begin
  {v0.67}
  CheckCalData;
  {/v0.67}
  CalData.ChangeFileName(FileNameEdit.Text);
end;

procedure TCalibrationForm.FormDestroy(Sender: TObject);
begin
  FCalData.Free;
  FCalData := nil;
  //CalibrationForm := nil;
end;

procedure TCalibrationForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

{v0.65}
procedure TCalibrationForm.DelBtnClick(Sender: TObject);
//var o: TULObj;
begin
  {v0.67}
  if FilesGrid.Obj <> nil then
  {/v0.67}
    FilesGrid.Obj.ChildsDelete(0, rfSelected);//ulrectyp
//  o := FilesGrid.Obj.ActiveChild;
//  if o <> nil then
//    o.Free;
end;

procedure TCalibrationForm.ComposePeaksBtnClick(Sender: TObject);
begin
  {v0.67}
  CheckCalData;
  {/v0.67}
  CalData.ComposePeaks;
end;


procedure TCalibrationForm.PeaksGridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
var o: TULObj;
begin
   o := PeaksGrid.Obj.ActiveChild;
   if o <> nil then
     PeakLevelsGrid.Obj := o;
end;

procedure TCalibrationForm.CreatePeakLevelBtnClick(Sender: TObject);
var
//  ucpl: TUCPLObj;
  o: TULObj;
begin
  o := PeakLevelsGrid.Obj;
  if o <> nil then begin
    {ucpl := TUCPLObj}(o.Add(UCPLID));
  end;
end;

{/v0.65}
procedure TCalibrationForm.SelectFileNameBtnClick(Sender: TObject);
begin
  if FileNameEdit.Text <> '' then
    ESaveDialog.FileName := FileNameEdit.Text;
  if ESaveDialog.Execute then begin
    FileNameEdit.Text := ESaveDialog.FileName;
    if FileExists(ESaveDialog.FileName) then begin
      {v0.67}
      CheckCalData;
      {/v0.67}
      CalData.SetFileName(ESaveDialog.FileName, omRead);
      UpdateControls;
    end;
  end;
end;

procedure TCalibrationForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if FCalData <> nil then
    CanClose := FCalData.CanClose;
end;

{v0.67}
function CalibrationFormOpen(const AFileName: string; AMode: TOpenMode): TCalibrationForm;
begin
  Result := TCalibrationForm.Create(Application);
  with Result do begin
    CalData := TCalData.Create(AFilename, AMode);
    if ExtractFilePath(AFileName) = '' then
      InitialDir := DataDir;
    Result.FormStyle := fsMDIChild;
    Show;
  end;
end;
{/v0.67}

end.
