unit DrvLogu;
{ Logging uLAN modules communication }
{
  (C) 2000 - 2002 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

{$I define.pas}
interface
uses
  UtlType, PropUtl, ExeLogu;

procedure DrvLogInit;
procedure DrvLogDone;
procedure DrvLog(const msg: string);

procedure DrvLogRegister;

const
  UseDrvLog: boolean = false;

implementation

const
  dlog: TExeLog = nil;

procedure DrvLogInit;
{var l: TExeLog;}
begin
  {v0.19}
  if not UseDrvLog then
    exit;
  {/v0.19}
  if dlog <> nil then
    exit;
  dlog := TExeLog.Create(nil, 'DRV.LOG');
end;

procedure DrvLogDone;
begin
  dlog.Free;
end;

procedure DrvLog(const msg: string);
begin
  if dlog = nil then
    exit;
  dlog.Log(msg);
end;

procedure DrvLogRegister;
begin
  ConfigReadWriteValue(nil, rwRead, LogSec, 'UseDrvLog', @UseDrvLog, ptByte);
end;
{
initialization
  DrvLogInit;

finalization
  DrvLogDone;
}
end.
