program MakeClas;
{$APPTYPE CONSOLE}
uses
  ClassRWu in 'ClassRWu.pas';
const
  Creator: TClassRW = nil;

procedure Help;
begin
writeln('Usage: MakeClas source[.pas]');
writeln('  ClassRW object (reader/writer of source TObject descendant files)');

writeln('  Creates published part for all fields defined in the first private');
writeln('  part of the class declaration.');
writeln;

writeln('  Assumes the following format of the source file:');
writeln('  - no TAB characters, just spaces');
writeln('  - every field on its own line');
writeln('  - pascal keyword in lowercase (class private protected public end)');
writeln('  - spaces around " = "');
writeln('  - no spaces: "class(", "end;"');
writeln;
writeln('  Creates file with the same name as the input file but with .tmp extension');
writeln('  and writes to it published part of the class and definition of the');
writeln('  class Get and Set function for the published properties.');

end;

begin
  if paramcount = 0 then
    Help
  else begin
    Creator := TClassRW.Create(paramstr(1));
    try
      Creator.Run;
    finally
      Creator.Free;
    end;
  end;
  writeln('Press Enter to finish.');
  readln;
end.
