unit AboutFrm;{ "About program" form }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  {v0.50}
  SysUtils, FileEditFrm,
  {/v0.50}
  Buttons, ExtCtrls, ulantype, URLLabel;

type
  TULAboutBox = class(TForm)
    Panel1: TPanel;
    OKButton: TBitBtn;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    Label1: TLabel;
    URLLabel1: TURLLabel;
    Label2: TLabel;
    URLLabel2: TURLLabel;
    Label3: TLabel;
    URLLabel3: TURLLabel;
    procedure FormCreate(Sender: TObject);
    procedure Label1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ULAboutBox: TULAboutBox;

implementation

{$R *.DFM}

procedure TULAboutBox.FormCreate(Sender: TObject);
begin
   Version.Caption := 'Version ' + uLanVersion;
end;

{v0.50}
procedure TULAboutBox.Label1Click(Sender: TObject);
var fn: string;
begin
  fn := ExtractFilePath(Application.ExeName) + 'Copying';
  if FileExists(fn) then begin
    with TFileEditForm.Create(Application) do begin
      FormStyle := fsNormal;
      Visible := false;
      Memo.Lines.LoadFromFile(fn);
      ShowModal;
    end;
  end;
end;
{/v0.50}

end.

