program CHROMuLAN;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

{%ToDo 'CHROMuLAN.todo'}

uses
  FrstUnit in 'FrstUnit.pas',
  Forms,
  Main in 'Main.pas' {MainForm},
  SpecForm in 'SpecForm.pas' {SpectrumForm},
  MargDial in 'MargDial.pas' {MarginsDialog},
  Plotu in 'Plotu.pas',
  Spectrum in 'Spectrum.pas',
  UlanType in 'UlanType.pas',
  DebugFrm in 'DebugFrm.pas' {DebugForm},
  DrawBuf in 'DrawBuf.pas',
  AboutFrm in 'AboutFrm.pas' {ULAboutBox},
  UlanGlob in 'UlanGlob.pas',
  DevMode in 'DevMode.pas',
  DevSetFr in 'DevSetFr.pas' {DevSetupForm},
  FiltDlg in 'FiltDlg.pas' {FilterParsForm},
  ExpImpu in 'ExpImpu.pas',
  MouseLin in 'MouseLin.pas',
  Axisu in 'Axisu.pas',
  PumpFrm in 'PumpFrm.pas' {PumpForm},
  ULAu in 'ULAu.pas',
  Report in 'Report.pas' {Form2},
  MathCopr in 'MathCopr.pas',
  FileNewDlg in 'FileNewDlg.pas' {FileNewDialog},
  AnalSetupFrm in 'AnalSetupFrm.pas' {AnalSetupForm},
  ULDRu in 'ULDRu.pas',
  Channelsu in 'Channelsu.pas',
  AcqInfou in 'AcqInfou.pas',
  ULPrgu in 'ULPrgu.pas',
  AAFrm in 'AAFrm.pas' {AAForm},
  Prgu in 'Prgu.pas',
  Sequenceu in 'Sequenceu.pas',
  Peaksu in 'Peaksu.pas',
  ULPrnFrm in 'ULObj\ULPrnFrm.pas' {ULPrnForm},
  ULObjPrn in 'ULObj\ULObjPrn.pas',
  SeqFrm in 'SeqFrm.pas' {SeqForm},
  SModulu in 'SModulu.pas',
  ULDrvSetFrm in 'ULDrvSetFrm.pas' {ULDrvSetForm},
  OptionsFrm in 'OptionsFrm.pas' {OptionsForm},
  ULDrvFilteru in 'ULDrvFilteru.pas',
  MikroType in 'MikroType.pas',
  SeqPrgToDevu in 'SeqPrgToDevu.pas',
  ULScriptu in 'ULScriptu.pas',
  ULScriptType in 'ULScriptType.pas',
  ProcessFrm in 'ProcessFrm.pas' {ProcessForm},
  Simulationu in 'Simulationu.pas',
  PickMethodPeakFrm in 'PickMethodPeakFrm.pas' {PickPeakForm},
  ControlFrm in 'ControlFrm.pas' {ControlForm},
  OvrManu in 'OvrManu.pas',
  CalibrationFrm in 'CalibrationFrm.pas' {CalibrationForm},
  CompCalu in 'CompCalu.pas',
  ComInfo in 'CULLib\ComInfo.pas' {CommInfoForm},
  Processoru in 'Processoru.pas',
  Templateu in 'Templateu.pas',
  DataFileu in 'DataFileu.pas',
  CalDatau in 'CalDatau.pas',
  LogFrm in 'CULLib\LogFrm.pas' {LogForm},
  MailerFrm in 'MailerFrm.pas' {MailerForm},
  LogSetupFrm in 'LogSetupFrm.pas' {LogSetupForm};

{$R *.RES}
exports
  ULDREDIT,
  ULAEDIT
  {ULDRBROWSE
   ULDBROWSE}
   ;
begin
  Application.HelpFile := 'CHROMuLAN.hlp';
  Application.Title := 'CHROMuLAN';
  Application.CreateForm(TMainForm, MainForm);
  Application.CreateForm(TULDrvSetForm, ULDrvSetForm);
  Application.CreateForm(TOptionsForm, OptionsForm);
  Application.CreateForm(TCommInfoForm, CommInfoForm);
  Application.CreateForm(TMailerForm, MailerForm);
  Application.CreateForm(TLogSetupForm, LogSetupForm);
  if not MainForm.OneInstance.IsFirstInstance then
    exit;
  Application.CreateForm(TMarginsDialog, MarginsDialog);
  Application.CreateForm(TULAboutBox, ULAboutBox);
  Application.CreateForm(TDevSetupForm, DevSetupForm);
  Application.CreateForm(TCommInfoForm, CommInfoForm);
  Application.CreateForm(TFilterParsForm, FilterParsForm);
  {Application.CreateForm(TDebugForm, DebugForm);}
  Application.CreateForm(TForm2, Form2);
  {v0.10}{/v0.10
  if paramcount > 0 then begin
    CreateSpectrumForm(paramstr(1), omRead);
  end;}
  Application.Run;
end.

