unit UCPRType;
 { Calibration peaks record declaration }
interface
uses
  UlanType, ULRecTyp;{UlanRecs.lst}

const
  UCPRID = ord('U') + 256*ord('C') + 256*256*ord('P') + 256*256*256*ord('R');

type
  TUCPRRec = packed record {<Caption="Calib.Peak" SortExp=X
    ChildRecIDs=UCPLID Uses=UCPLType
    Enabled=1 Visible=1 SortedByNumber=1
    EditFieldList=PeakName,X,Response,DataName
    BrowseFieldList=X,PeakName,Response,DataName>}
    Head: TULRecHead;
    Info: TULRecInfo;
    X: TXValue;{<UserCoef=60 NumDec=2 Caption="X [min]" Enabled=1>}
      { Average position of the peak (X of its maximum). }
    PeakName: TPeakName;{<Caption=Name Enabled=1>}
      { User assigned name of the peak. Gets also assigned from Method peaks
        of the same X (in Window interval) during peaks autodetection. }
    Response: TResponse;{<Enabled=1>}
      { Response of the compound in the detector, e.g. extinction coeficient }
    DataName: string;{<Enabled=1 Caption="Data name"
      Hint="In what data line the peak should be located (e.g.: B for blue line in AAA)">}
      { If more data acquired in data chromatogram (e.g. for different wavelengths)
        then here can be the name of the data (should be the same as
        ULADType.DataName). If not specified, the first data will be assumed.
        Introduced in Chromulan v0.25 }
    ResponseBase: TResponseBase;{<Enabled=1>}
    CurveFitType: TCurveFitType;
    OriginUse: TOriginUse;
    Param1: double;
    Param2: double;
    Param3: double;
    Param4: double;
    Param5: double;
    FromFileCount: integer;
    WeightSum: single;
  end;

  PUCPRRec = ^TUCPRRec;

implementation

end.
