unit ULPrnFrm; {v0.31}
{ ULObj print options form. }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, ExtCtrls, Language, SubClasser;

type
  TULPrnForm = class(TForm)
    TopPanel: TPanel;
    LeftPanel: TPanel;
    RightPanel: TPanel;
    Splitter1: TSplitter;
    HeaderCheckListBox: TCheckListBox;
    ItemCheckListBox: TCheckListBox;
    HeaderPanel: TPanel;
    ItemPanel: TPanel;
    HeaderLabel: TLabel;
    ItemLabel: TLabel;
    BottomPanel: TPanel;
    OKButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private declarations }
    FObj: TObject;
    {function GetBrowseChild(var AChild: TObject):boolean;}
  protected
    procedure SetObj(AObj: TObject);
    procedure DoOnOK;
    procedure ObjToForm;
    procedure FormToObj;
  public
    { Public declarations }
    property Obj: TObject read FObj write SetObj;
  end;

var
  ULPrnForm: TULPrnForm;

implementation
uses
  ULRecTyp, ULObju;
{$R *.DFM}

procedure TULPrnForm.FormCreate(Sender: TObject);
begin
  Obj := CurULObj;
end;

procedure TULPrnForm.SetObj(AObj: TObject);
begin
  if FObj <> nil then begin
    TULObj(FObj).UserUnregister(Self);
    FObj := nil;
  end;
  FObj := AObj;
  if FObj <> nil then begin
    CurULObj := nil;
    TULObj(FObj).UserRegister(Self);
    ObjToForm;
  end;
end;

procedure TULPrnForm.FormDestroy(Sender: TObject);
begin
  Obj := nil;
end;

procedure TULPrnForm.ObjToForm;
var
  c: TULObj;
  s: string;
begin
  if Obj = nil then
    exit;
  s := '';
  TULObj(Obj).ObjDesc.FieldsToCheckListBox(ffToPrint, HeaderCheckListBox, s);
  if s <> '' then
    HeaderLabel.Caption := s + ' ' + GetTxt({#}'fields');
  if TULObj(Obj).GetBrowseChild(c) then begin
    s := '';
    c.ObjDesc.FieldsToCheckListBox(ffToPrint, ItemCheckListBox, s);
    if s <> '' then
      ItemLabel.Caption := s + ' ' + GetTxt({#}'fields');
  end;
end;

procedure TULPrnForm.FormToObj;
var
  c: TULObj;
begin
  if Obj = nil then
    exit;
  TULObj(Obj).ObjDesc.CheckListBoxToFields(ffToPrint, HeaderCheckListBox);
  if TULObj(Obj).GetBrowseChild(c) then
    c.ObjDesc.CheckListBoxToFields(ffToPrint, ItemCheckListBox);
end;             {controls dodrawtext}

procedure TULPrnForm.DoOnOK;
begin
  FormToObj;
end;

procedure TULPrnForm.OKButtonClick(Sender: TObject);
begin
  DoOnOK;
end;

end.
