unit ULObjAct;{v0.22}

interface
uses
  Classes, ActnList, Menus, Clipbrd, Dialogs, Windows,
  ULRecTyp, Msgu, Language, ULObjPrn;

type

  TULObjActions = class(TComponent)
  private
    FHeaderAction: TAction;
    FEditFocusedAction : TAction;
    FBrowseFocusedAction : TAction;
    FCopySelectedAction : TAction;
    FDeleteSelectedAction : TAction;
    FDeleteAllAction : TAction;
    FPasteAction: TAction;
    {v0.25}
    FSaveAction: TAction;
    {/v0.25}
    {v0.36}
    FSaveAsAction: TAction;
    {/v0.36}
    {v0.24}
    { child section }
    FChildEditModalAction: TAction;{just for sysop mode}
    FChildAddAction: TAction;
      { append new child }
    FChildInsertAction: TAction;
      { insert new child before active one }
    FChildDeleteAction: TAction;
      { delete active child }
    FChildFileSelectAction: TAction;
      { select file for active child active field (assuming it is of Type=FileName) }
    {v0.25}
    FChildsSortAction: TAction;
    {/v0.25}

    { options section }
    FGridEditEnabled: TAction;
      { toggle EditEnabled flag for ULStringGrid (can modify values in browser?) }
    FGridInternalValuesEnabled: TAction;
      { toggle InternalValuesEnabled flag for ULStringGrid (show internal values?) }
    FGridAllDetails: TAction;
      { toggle AllDetails flag for ULStringGrid (show all fields?) }
    FGridAutoSizeBrowseCols: TAction;
      { toggle AutoSizeBrowseCols for ULStrinGrid (adjust columns width to maximal
        text width of values in it?) }
    FGridAlwaysShowEditor: TAction;

    FMenuOwner: TComponent;
      { assigned during localmenubuild }
    FGrid: TComponent;
      { assigned during localmenubuild }
    {FOpenDialog: TOpenDialog;}
    {/v0.24}
    {v0.30}
    FCurMenu: TMenu;
    {/v0.30}
    {v0.31}
    FPrintOptionsEdit: TAction;
    FPrint: TAction;
    FULObjPrn: TULObjPrn;
    {/v0.31}
    {v0.48}
    procedure SetCurMenu(AMenu: TMenu);
    {/v0.48}
  public
    constructor Create(Owner: TComponent); reintroduce;
      { owner is ULObj }
    destructor Destroy;override;
    procedure Edit(Sender: TObject);
    procedure EditFocused(Sender: TObject);
    {v0.24}
    procedure ChildEditModal(Sender: TObject);
    {/v0.24}
    procedure BrowseFocused(Sender: TObject);
    procedure CopySelected(Sender: TObject);
    procedure DeleteSelected(Sender: TObject);
    procedure DeleteAll(Sender: TObject);
    procedure Paste(Sender: TObject);
    procedure LocalMenuBuild(AMenuOwner: TComponent; Menu:TMenu);
    {v0.25}
    procedure Save(Sender: TObject);
    procedure ChildsSort(Sender: TObject);
    {/v0.25}
    {v0.36}
    procedure SaveAs(Sender: TObject);
    {/v0.36}
    {v0.24}
    procedure ChildAdd(Sender: TObject);
    procedure ChildInsert(Sender: TObject);
    procedure ChildDelete(Sender: TObject);
    procedure ChildFileSelect(Sender: TObject);
    procedure GridEditEnabled(Sender: TObject);
    procedure GridInternalValuesEnabled(Sender: TObject);
    procedure GridAllDetails(Sender: TObject);
    procedure GridAutoSizeBrowseCols(Sender: TObject);
    procedure GridAlwaysShowEditor(Sender: TObject);
    {v0.44}
    procedure ChildBtnEditClick(Sender: TObject);
    {/v0.44}
    {v0.30}
    procedure MenuActionAdd(AAction: TAction);
      { called by ulobj users (through the ulobj) to as response to
        cmULObjUserActionNeeded message sent during creation of the local menu }
    {/v0.30}
    {v0.31}
    procedure PrintOptionsEdit(Sender: TObject);
    procedure Print(Sender: TObject);
    {/v0.31}

    property MenuOwner: TComponent read FMenuOwner;
    {/v0.24}
    {v0.48}
    property CurMenu: TMenu read FCurMenu write SetCurMenu;
      { assign explicitely only  if actions should be added to other
        menu then the one in the ULStringGrid form; will assign
        FCurMenu, FMenuOwner; than can be called MenuActionAdd any times
        needed, should be finished by assigning nil to CurMenu }
    {/v0.48}
  end;

implementation
uses
  ULObju, ULObjDes{v0.24}, ULStringGrid{/v0.24};

constructor TULObjActions.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  FHeaderAction := TAction.Create(Self);
    FHeaderAction.Caption := GetTxt({#}'Header');
    FHeaderAction.OnExecute := Edit;
  {v0.24}
  FChildEditModalAction := TAction.Create(Self);
    FChildEditModalAction.Caption := GetTxt({#}'Edit Modal');
    FChildEditModalAction.OnExecute := ChildEditModal;
  {/v0.24}
  FEditFocusedAction := TAction.Create(Self);
    FEditFocusedAction.Caption := GetTxt({#}'Edit');
    FEditFocusedAction.OnExecute := EditFocused;
  FBrowseFocusedAction := TAction.Create(Self);
    FBrowseFocusedAction.Caption := GetTxt({#}'Browse');
    FBrowseFocusedAction.OnExecute := BrowseFocused;

  FCopySelectedAction := TAction.Create(Self);
    FCopySelectedAction.Caption := GetTxt({#}'Copy Selected');
    FCopySelectedAction.OnExecute := CopySelected;

  FDeleteSelectedAction := TAction.Create(Self);
    FDeleteSelectedAction.Caption := GetTxt({#}'Delete Selected');
    FDeleteSelectedAction.OnExecute := DeleteSelected;

  FDeleteAllAction := TAction.Create(Self);
    FDeleteAllAction.Caption := GetTxt({#}'Delete All');
    FDeleteAllAction.OnExecute := DeleteAll;

  FPasteAction := TAction.Create(Self);
    FPasteAction.Caption := GetTxt({#}'Paste');
    FPasteAction.OnExecute := Paste;
  {v0.25}
  FSaveAction := TAction.Create(Self);
    FSaveAction.Caption := GetTxt({#}'Save');
    FSaveAction.OnExecute := Save;
  {/V0.25}
  {v0.36}
  FSaveAsAction := TAction.Create(Self);
    FSaveAsAction.Caption := GetTxt({#}'Save As');
    FSaveAsAction.OnExecute := SaveAs;
  {/v0.36}

  FChildAddAction := TAction.Create(Self);
    FChildAddAction.Caption := GetTxt({#}'Add');
    FChildAddAction.OnExecute := ChildAdd;
  FChildInsertAction := TAction.Create(Self);
    FChildInsertAction.Caption := GetTxt({#}'Insert');
    FChildInsertAction.OnExecute := ChildInsert;
  FChildDeleteAction := TAction.Create(Self);
    FChildDeleteAction.Caption := GetTxt({#}'Delete');
    FChildDeleteAction.OnExecute := ChildDelete;
  FChildFileSelectAction := TAction.Create(Self);
    FChildFileSelectAction.Caption := GetTxt({#}'Select File');
    FChildFileSelectAction.OnExecute := ChildFileSelect;
  {v0.25}
  FChildsSortAction := TAction.Create(Self);
    FChildsSortAction.Caption := GetTxt({#}'Sort');
    FChildsSortAction.OnExecute := ChildsSort;
  {/v0.25}

  FGridEditEnabled := TAction.Create(Self);
    FGridEditEnabled.Caption := GetTxt({#}'Edit Enabled');
    FGridEditEnabled.OnExecute := GridEditEnabled;
  FGridInternalValuesEnabled := TAction.Create(Self);
    FGridInternalValuesEnabled.Caption := GetTxt({#}'Internal values');
    FGridInternalValuesEnabled.OnExecute := GridInternalValuesEnabled;
  FGridAllDetails := TAction.Create(Self);
    FGridAllDetails.Caption := GetTxt({#}'All Details');
    FGridAllDetails.OnExecute := GridAllDetails;
  FGridAutoSizeBrowseCols := TAction.Create(Self);
    FGridAutoSizeBrowseCols.Caption := GetTxt({#}'Autosize Columns');
    FGridAutoSizeBrowseCols.OnExecute := GridAutoSizeBrowseCols;
  FGridAlwaysShowEditor := TAction.Create(Self);
    FGridAlwaysShowEditor.Caption := GetTxt({#}'Always Show Editor');
    FGridAlwaysShowEditor.OnExecute := GridAlwaysShowEditor;
  {v0.31}
  FPrintOptionsEdit := TAction.Create(Self);
    FPrintOptionsEdit.Caption := GetTxt({#}'Print options');
    FPrintOptionsEdit.OnExecute := PrintOptionsEdit;

  FPrint := TAction.Create(Self);
    FPrint.Caption := GetTxt({#}'Print');
    FPrint.OnExecute := Print;
  {/v0.31}
end;

destructor TULObjActions.Destroy;
begin
  {v0.31}
  FULObjPrn.Free;
  {/v0.31}
  inherited Destroy;
end;

procedure TULObjActions.LocalMenuBuild(AMenuOwner: TComponent; Menu: TMenu);
var
  i: integer;
  fd: TULObjFldDesc;
  f: TULObjField;
  o: TULObj;
  mi: TMenuItem;
  {v0.24}
  g: TULStringGrid;
  ac: TULObj;
  acod: TULObjDesc;
  acf: TULObjField;
  acfd: TULObjFldDesc;
  {/v0.24}
  {v0.44}
  odesc: TULObjDesc;
  {addLineItem: TMenuItem;}
  {itemsSinceLine: integer;}
  {nonLineItems:integer;}
  {/v0.44}


  function AddAction(m: TMenuItem; a:TAction{v0.24}; chk:boolean{/v0.24}): TMenuItem;
  var mi: TMenuItem;
  begin
    mi := TMenuItem.Create(MenuOwner);
    mi.Action := a;{OnClick := MenuItemClick;}
    {v0.24}
    mi.Checked := chk;
    {/v0.24}
    m.Add(mi);
    Result := mi;
  end;

  {v0.44}
  procedure AddLine(m: TMenuItem);
  var mi: TMenuItem;
  begin
    {if addLineItem }
    mi := TMenuItem.Create(MenuOwner);
    mi.Caption := '-';
    m.Add(mi);
  end;
  {/v0.44}

  procedure AddFocused;
  var
    foc: TMenuItem;
    {v0.24}
    {v0.24
    ac: TULObj;
    acod: TULObjDesc;}
  begin
    {v0.44}
    if omFocused in odesc.ExcludedMenuItems then
      exit;
    {/v0.44}
    {v0.24}
    if ac = nil then
      exit;
    {/v0.24
    ac := TULObj(Owner).ActiveChild;
    if ac = nil then
      exit;
    acod := ac.ObjDesc;}

    {0.44}
    if ac.IsFlagSet(rfVisible) and ac.IsFlagSet(rfEnabled) then
    begin
      foc := TMenuItem.Create(MenuOwner);
      if ac <> nil then begin
        foc.Caption := acod.Caption;
      end else begin
        foc.Caption := GetTxt({#}'Focused');
      end;


      AddAction(foc, FEditFocusedAction, false);
      {v0.24}
      if UserMode = umSysOp then
        AddAction(foc, FChildEditModalAction, false);
      {/v0.24}

      if acod.ChildRecIDCount > 0 then begin
        AddAction(foc, FBrowseFocusedAction, false);
      end;

      {v0.24}
      if not ac.IsFlagSet(rfCantDelete) then begin {ulrectyp}
        {v0.44}
        if not (omChildDelete in odesc.ExcludedMenuItems) then
        {/v0.44}
          AddAction(foc, FChildDeleteAction, false);
      end;
      {/v0.24}

      Menu.Items.Add(foc);
    end;
  end;

  procedure AddOptions;
  var
    opt: TMenuItem;
  begin
    {v0.44}
    if omGridOptions in odesc.ExcludedMenuItems then
      exit;
    {/v0.44}
    if g = nil then
      exit;
    opt := TMenuItem.Create(MenuOwner);
    opt.Caption := GetTxt({#}'Grid Options');

    AddAction(opt, FGridEditEnabled, g.EditEnabled);

    AddAction(opt, FGridInternalValuesEnabled, g.InternalValuesEnabled);

    AddAction(opt, FGridAllDetails, g.AllDetails);

    AddAction(opt, FGridAutoSizeBrowseCols, g.AutoSizeBrowseCols);
    AddAction(opt, FGridAlwaysShowEditor, g.AlwaysShowEditor);

    Menu.Items.Add(opt);{ulrectyp}
  end;

  procedure AddDefault;
  var
    {mi: TMenuItem;}
    frm:UINT;
  begin
    {v0.44}
    if not (omHeader in odesc.ExcludedMenuItems) then
    begin
      if odesc.FieldCount > 0 then {ulobjdes}
        AddAction(Menu.Items, FHeaderAction, false);
    end;
    {/v0.44
      AddAction(Menu.Items, FHeaderAction, false);}

    AddFocused;
    if o.ChildWithFlagCount(rfSelected) > 0 then begin
      {v0.44}
      if not (omCopySelected in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FCopySelectedAction, false);
      {v0.44}
      if not (omDeleteSelected in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FDeleteSelectedAction, false);
    end;
    if o.ChildCount > 0 then begin
      {v0.44}
      if not (omDeleteAll in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FDeleteAllAction, false);
    end;
    {v0.24}
    frm := RegisterClipboardFormat(ULObjFormat);
    {ulrectyp}
    if Clipboard.HasFormat(frm) then begin
      {v0.44}
      if not (omPaste in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FPasteAction, false);
    end;
    {v0.25}
    if (o.Owner is TULObj) and (TULObj(o.Owner).RecID = ULFID) and
      (TULObj(o.Owner).FileName <> '') {v0.41} or o.IsFlagSet(rfAskForSave){/v0.41}
    then begin
      AddAction(Menu.Items, FSaveAction, false).Enabled := o.Modified;{tmenuitem}
      {v0.36}
      {v0.44}
      if not (omSaveAs in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FSaveAsAction, false);
      {/v0.36}
    end;
    {/v0.25}
    {v0.44}
    AddLine(Menu.Items);
    {/v0.44
    mi := TMenuItem.Create(Self);
    mi.Caption := '-';
    Menu.Items.Add(mi);}
    {v0.25}
    if (o.ChildCount > 0) and o.IsFlagSet(rfChildSorted) then begin
      {v0.44}
      if not (omSort in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FChildsSortAction, false);
    end;
    {/v0.25}

    {v0.24}

    {v0.44}
    if not (omChildAdd in odesc.ExcludedMenuItems) then
    {/v0.44}
      AddAction(Menu.Items, FChildAddAction, false);

    {v0.25}
    if not o.IsFlagSet(rfChildSorted) then
    {/v0.25}
    begin
      {v0.44}
      if not (omChildInsert in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FChildInsertAction, false);
    end;
    if ac <> nil then begin
      {v0.44}
      if not (omChildDelete in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FChildDeleteAction, false);
    end;
    if (acfd <> nil) and acfd.IsFileName then begin
      {v0.44}
      if not (omChildFileSelect in odesc.ExcludedMenuItems) then
      {/v0.44}
        AddAction(Menu.Items, FChildFileSelectAction, false);
    end;

    {v0.44}
    AddLine(Menu.Items);
    {/v0.44
    mi := TMenuItem.Create(Self);
    mi.Caption := '-';
    Menu.Items.Add(mi);}
    {v0.24}
    AddOptions;
    {/v0.24}

    {v0.31}

    {v0.44}
    AddLine(Menu.Items);
    {/v0.44
    mi := TMenuItem.Create(Self);
    mi.Caption := '-';
    Menu.Items.Add(mi);}

    {v0.44}
    if not (omPrintOptions in odesc.ExcludedMenuItems) then
    {/v0.44}
      AddAction(Menu.Items, FPrintOptionsEdit, false);
    {v0.44}
    if not (omPrint in odesc.ExcludedMenuItems) then
    {/v0.44}
      AddAction(Menu.Items, FPrint, false);

    {/v0.31}
  end;

begin
  {v0.24}
  ac := nil;
  acod := nil;
  {acf := nil;}
  acfd := nil;
  FGrid := nil;
  g := nil;
  FMenuOwner := AMenuOwner;
  o := TULObj(Owner);
  {v0.44}
  odesc := o.ObjDesc;
  {ddLineItem := nil;}
  {/v0.44}
  {v0.30}
  FCurMenu := Menu;
  try
  {/v0.30}
    if MenuOwner is TULStringGrid then begin
      g := TULStringGrid(MenuOwner);
      FGrid := g;
    end;

    ac := TULObj(Owner).ActiveChild;
    if ac <> nil then begin
      acod := ac.ObjDesc;
      i := o.ActiveChildFieldIndex;
      if i >= 0 then begin
        acf := ac.Fields[i];
        acfd := acf.FldDesc;
      end;
    end;
    {/v0.24}

    while Menu.Items.Count > 0 do begin
      Menu.Items[Menu.Items.Count - 1].Free;
    end;
    if Menu.Items.Count = 0 then begin
      {v0.24}
      {/v0.24
      o := TULObj(Owner);
      }
      {v0.41}
      o.UsersNotify(cmULObjUserFirstActionNeeded);
      {/v0.41}
      {v0.44}
      if Menu.Items.Count <> 0 then begin
        AddLine(Menu.Items);
      end;
      {/v0.44}

      AddDefault;

      for i := 0 to o.ObjDesc.FieldCount - 1 do begin
        fd := o.ObjDesc.Fields[i];
        f := o.Fields[i];
        if fd.IsMethod and Assigned(TNotifyEvent(f.Method)) then begin
          {fd.Method := f.Method;{updates fd.Action}
          mi := TMenuItem.Create(MenuOwner);
          mi.Caption := fd.Caption;
          f.Action.Caption := fd.Caption;
          mi.Action := f.Action;{OnClick := MenuItemClick;}
          Menu.Items.Add(mi);
        end;
      end;
      {LocalMenu.Width := mw;}
    end;
  {v0.30}
    o.UsersNotify(cmULObjUserActionNeeded);
  finally
    FCurMenu := nil;
  end;
  {/v0.30}
end;

{v0.30}
procedure TULObjActions.MenuActionAdd(AAction: TAction);
var mi: TMenuItem;
begin
  if (FCurMenu = nil) or (MenuOwner = nil) then
    exit;
  mi := TMenuItem.Create(MenuOwner);
  mi.Action := AAction;
  FCurMenu.Items.Add(mi);
end;

{procedure TULObjActions.RemoveAction(AActionOwner: TComponent);
begin
  all menus should be registered/unregisted at Self;
  all ul obj users that called menuactionadd should call remove action before
  destroying itself, the Self should then scan all the menus and remove all
  actions that have this owner (set that menuitem.action = nil);
  Self should not be destroyed until it has some registered menus

  or use delphi freenotify mechanism?
end;!!!}
{/v0.30}

procedure TULObjActions.Edit(Sender: TObject);
begin
  TULObj(Owner).Edit;
end;

procedure TULObjActions.EditFocused(Sender: TObject);
var a: TULObj;
begin
  a := TULObj(Owner).ActiveChild;
  if a <> nil then
    a.Edit;
end;

{v0.24}
procedure TULObjActions.ChildEditModal(Sender: TObject);
var a: TULObj;
begin
  a := TULObj(Owner).ActiveChild;
  if a <> nil then
    a.EditModal;
end;
{/v0.24}

procedure TULObjActions.BrowseFocused(Sender: TObject);
var a: TULObj;
begin
  a := TULObj(Owner).ActiveChild;
  if a <> nil then
    a.Browse; {ulmtype}
end;

procedure TULObjActions.CopySelected(Sender: TObject);
begin
  Clipboard.Assign(TULObj(Owner));
end;

procedure TULObjActions.DeleteSelected(Sender: TObject);
begin
  if ShowMessage(GetTxt({#}'Really delete selected items?'), smNoYes, 0) = cmYes then
    TULObj(Owner).ChildsDelete(0, rfSelected);
end;

procedure TULObjActions.DeleteAll(Sender: TObject);
begin
  if ShowMessage(GetTxt({#}'Really delete all items?'), smNoYes, 0) = cmYes then
    TULObj(Owner).ChildsDelete(0, 0);
end;

procedure TULObjActions.Paste(Sender: TObject);
begin
  TULObj(Owner).Assign(Clipboard);
end;
{/v0.22}

{v0.25}
procedure TULObjActions.ChildsSort(Sender: TObject);
begin
  TULObj(Owner).Sort;
end;

procedure TULObjActions.Save(Sender: TObject);
var o: TULObj;
begin
  o := TULObj(Owner);{aapgtype aapgobju}
  if (o.Owner is TULObj) and (TULObj(o.Owner).RecID = ULFID) then
    TULObj(o.Owner).Save;
end;

{v0.36}
procedure TULObjActions.SaveAs(Sender: TObject);
var
  o: TULObj;
begin
  o := TULObj(Owner);
  {v0.37}
  o.DoFileSaveAs;

{/v0.37  if (o.Owner is TULObj) and (TULObj(o.Owner).RecID = ULFID) then
    TULObj(o.Owner).DoFileSaveAs;}
end;
{/v0.36}

{v0.24}
procedure TULObjActions.ChildAdd(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    NewRec(false);
  end;
end;

procedure TULObjActions.ChildInsert(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    NewRec(true);
  end;
end;

procedure TULObjActions.ChildDelete(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    DelRec;
  end;
end;

{v0.44}
procedure TULObjActions.ChildBtnEditClick(Sender: TObject);
var
  c: TULObj;
  o: TULObj;
  i: integer;
  f: TULObjField;
begin
  o := TULObj(Owner);
  c := o.ActiveChild;
  if c = nil then
    exit;
  i := o.ActiveChildFieldIndex;
  if i < 0 then
    exit;
  f := c.Fields[i];
  if f.FldDesc.IsFileName then
    f.DoFieldFileNameOpenSelect
  else if f.FldDesc.IsSetType then
    f.DoCheckListBoxFormExecute
  else if f.FldDesc.IsDir then
    f.DoDirSelect {v0.50}
  else if f.FldDesc.IsColor then
    f.DoColorSelect{/v0.50};
end;
{/v0.44}

procedure TULObjActions.ChildFileSelect(Sender: TObject);
{v0.24}
var
  c: TULObj;
  {f: TULObjField;}
  o: TULObj;
  i: integer;
{  opt:TOpenOptions;}
begin
  o := TULObj(Owner);
  c := o.ActiveChild;
  if c = nil then
    exit;
  i := o.ActiveChildFieldIndex;
  if i < 0 then
    exit;
  c.Fields[i].DoFieldFileNameOpenSelect;
{
  f := c.Fields[i];
  if FOpenDialog = nil then
    FOpenDialog := TOpenDialog.Create(Self);
  opt := FOpenDialog.Options;
  Include(opt, ofFileMustExist);
  FOpenDialog.Options := opt;
  FOpenDialog.Filter := c.Fields[i].FldDesc.Filter;
  FOpenDialog.FileName := f.AsString;
  if FOpenDialog.Execute then
    f.AsString := FOpenDialog.FileName; ulobju}
end;

{v0.24}
procedure TULObjActions.GridEditEnabled(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    EditEnabled := not EditEnabled;
  end;
end;

procedure TULObjActions.GridInternalValuesEnabled(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    InternalValuesEnabled := not InternalValuesEnabled;
  end;
end;

procedure TULObjActions.GridAllDetails(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    AllDetails := not AllDetails;
  end;
end;

procedure TULObjActions.GridAutoSizeBrowseCols(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    AutoSizeBrowseCols := not AutoSizeBrowseCols;
  end;
end;

procedure TULObjActions.GridAlwaysShowEditor(Sender: TObject);
begin
  if FGrid <> nil then with FGrid as TULStringGrid do begin
    AlwaysShowEditor := not AlwaysShowEditor;
  end;
end;
{/v0.24}

{v0.31}
procedure TULObjActions.PrintOptionsEdit(Sender: TObject);
begin
{  TULObj(Owner).PrintOptionsEdit;}
  {v0.36}
  if FULObjPrn = nil then
    FULObjPrn := TULObjPrn.Create(Owner, Owner);
  with FULObjPrn do begin
    ReportFormCreate;
    RepForm.ShowModal;
    ReportFormDestroy;
  end;
  {/v0.36}
end;

procedure TULObjActions.Print(Sender: TObject);
begin
  if FULObjPrn = nil then
    FULObjPrn := TULObjPrn.Create(Owner, Owner);
  FULObjPrn.Print;
end;
{/v0.31}

{v0.48}
procedure TULObjActions.SetCurMenu(AMenu: TMenu);
begin
  FCurMenu := AMenu;
  if FCurMenu <> nil then
    FMenuOwner := AMenu.Owner
  else
    FMenuOwner := nil;
end;
{/v0.48}

end.
