program data2txt;

{$APPTYPE CONSOLE}

uses
  SysUtils, Classes,
  UlanType, CmdLine;

const
  OptionCount = 6;
   oiInFn = 1;
   oiOutFn = 2;
   oiHeadSize = 3;
   oiTailSize = 4;
   oidx = 5;
   oix0 = 6;


  Options: array[1..OptionCount] of TOptionRec = (

    (OptionName: ' ';
     OptionDesc: 'Input binary data file name.';
     Flag: 0;
     Present: false;
     Mandatory: true;
     Option: otFileName;
     Param: ''),

    (OptionName:' ';
     OptionDesc:'Output text file file name. One x,y pair in ASCII per line.';
     Flag: 0;
     Present: false;
     Mandatory: false;
     Option: otFileName;
     Value: 0),

    (OptionName: 'h';
     OptionDesc: 'Binary file header size in bytes (to be skipped)';
     Flag: 0;
     Present: false;
     Mandatory: false;
     Option: otInt;
     Value: 0),

    (OptionName: 't';
     OptionDesc: 'Binary file tail size in bytes (to be skipped)';
     Flag: 0;
     Present: false;
     Mandatory: false;
     Option: otInt;
     Value: 0),

    (OptionName: 'd';
     OptionDesc: 'Defference between consecutive X values (if X values are not specified)' + #13#10 +
       'in the binary data file (can be negative).';
     Flag: 0;
     Present: false;
     Mandatory: false;
     Option: otSingle;
     Float: 0),

    (OptionName: '0';
     OptionDesc: 'Value of the first X value (if X values are not specified) in binary data file.';
     Flag: 0;
     Present: false;
     Mandatory: false;
     Option: otSingle;
     Float: 0)

    (OptionName: 'y';
     OptionDesc: 'Format of the Y value in the binary data file: byte, ';
     Flag: 0;
     Present: false;
     Mandatory: false;
     Option: otSingle;
     Float: 0)

  );


procedure Convert;
var
  n, ext: string;
  s: TFileStream;
  t: text;
  inFn, outFn: string;
  x, ys: single;
  yi: longint;
  dx: single;
const
  TxtExt = '.txt';
begin
//..\spa\test.spa -h976 -t672 -04000 -d-0.2
  inFn := Options[oiInFn].Param;
  outFn := Options[oiOutFn].Param;
  ext := UpperCase(ExtractFileExt(InFn));
  if ext = '.SPA' then begin
    if OutFn = '' then begin
      OutFn := ChangeFileExt(InFn, TxtExt)
    end else begin
      if ExtractFileExt(OutFn) = '' then
        OutFn := ChangeFileExt(OutFn, TxtExt);
    end;

    try
      s := TFileStream.Create(InFn, fmOpenRead);
      try
        AssignFile(t, OutFn);
        Rewrite(t);
        x := Options[oiX0].Float;
        dx := Options[oidX].Float;
        s.Position := Options[oiHeadSize].Value;
        try
          repeat
            s.Read(yi, sizeof(yi));
            writeln(t, x, ',', yi);
            if s.Position >= s.Size - Options[oiTailSize].Value then
              break;
            x := x + dx;
          until false;
        finally
          Close(t);
        end;
      finally
        s.Free;
      end;

    except
      writeln('Failed to open ' + InFn);
    end;
  end else begin
    writeln('Unknown extension ' + ext);
  end;
end;

//procedure WriteHelp;
//begin
//  writeln('Usage: data2txt inputfilename [outputfilename]');
//  writeln('Converts binary input data file to .txt file with x,y in ASCII per line.');
//end;

begin
  { TODO -oUser -cConsole Main : Insert code here }
  ProcessCommandLine(@Options, OptionCount);
  if paramcount = 0 then
    PrintOptionsHelp
  else begin
    Convert;
  end;
end.
