unit ULDPType;
{ ULDP device/module property description record. }
interface

uses
  UlanType, ULRecTyp, ModuType;{ULREC.LST}

const
  ULDPID = ord('U') + 256*ord('L') + 256*256*ord('D') + 256*256*256*ord('P');

type
  TULDPRec = packed record {<Caption="Property" Uses=ModuType
    Enabled=1 Visible=1 HasRecName=1 NameProp=PropDesc MainProp=ValueInPC
    BrowseFieldList=PropDesc,ValueInPC>}
    Head: TULRecHead;
    Info: TULRecInfo;
    PropIDStr: TModulePropIDStr;
    PropDesc: TModulePropDesc;
    TypeDesc: TModulePropTypeDesc;
    TypeID: TModulePropTypeID;{<Type=Enum>}
    PropFlags: TModulePropFlags;
    ValueInPC: AnsiString;{<Enabled=1 Hint="Set by user (or by program)">}
      {   Assigning a value to this property will cause its transfer to the
        module, as soon as the module sends the value back, it will be assigned
        also to ValueInDevice property.
           If the assigned value is the same as the previous one, the tranfer
        will not take place. Assign true to ForceTransfer value to force the tranfer.
           If the property is command, there is no need to use ForceTransfer
        it's enough to set ValueInPC <> 1, because it will be set to 0 after
        sending the value to device }
    ValueInDevice : AnsiString;{<Hint="Value received from the device">}
      { This property value is set only to values received from device }
    UpdateInterval: integer;{<Enabled=1>}
    ForceTransfer: boolean;{<Type=Enum>}
      { If set true runtime, then current ValueInPC will be resent to device,
        even if the value is the same as the previous one.
        This field will be cleared as soon as the ValueInPC is sent to device. }
  end;
  PULDPRec = ^TULDPRec;

const
  pnValueInPC = 'ValueInPC';
  pnValueInDevice = 'ValueInDevice';
{uldrtype}
implementation

end.
