unit ULPRType;
 { Peaks Record declaration }
interface
uses
  UlanType, ULRecTyp;{ULREC.LST}

const
  ULPRID = ord('U') + 256*ord('L') + 256*256*ord('P') + 256*256*256*ord('R');

type
  TULPRRec = packed record {<Caption="Peak" SortExp=X
    Enabled=1 Visible=1 SortedByNumber=1 Create1="Window := 10;"
    EditFieldList=PeakName,GroupName,Window,UsrPeakCoef,X,Width,AreaSize,Ratio,Amount,Response,InternalStandard,DataName
    BrowseFieldList=X,PeakName,AreaSize,UsrPeakCoef,Response,Amount,Window,InternalStandard,DataName>}
    Head: TULRecHead;
    Info: TULRecInfo;
    X1: TXValue;{<UserCoef=60 NumDec=2 Caption="X1 [min]">}
      { X value of the left integration limit of the peak }
    Y1: TYValue;{<Caption="Y1 [AU]">}
      { Y value of Left integration limit of the peak }
    Index1: TPointCount;{<Enabled=0>}
      { Index of the left limit point in raw data points array (zero based) }
    X2: TXValue;{<UserCoef=60 NumDec=2 Caption="X2 [min]">}
      { X value of the right integration limit of the peak }
    Y2: TYValue;{<Caption="Y2 [AU]">}
      { Y value of the right integration limit of the peak }
    Index2: TPointCount;
      { Index of the right limit point in raw data points array (zero based) }
    X: TXValue;{<UserCoef=60 NumDec=2 Caption="X [min]" Enabled=1>}
      { Position of the peak (X of its maximum). }
    Width: TXValue;{<UserCoef=60 NumDec=2 Caption="Width [min]">}
      { Width of the peak in the middle of its height in minutes. }
    Height: TYValue;{<Caption="Height [AU]">}
      { Max height of the peak. }
    AreaSize: TAreaSize;{<Caption=Area>}
      { Area of the peak. }
    Ratio: TRatio;{<UserCoef=0.01 NumDec=2 Caption="Content [%]">}
      { Ratio AreaSize/(AreaSize of all peaks). }
    PeakName: TPeakName;{<Caption=Name Enabled=1>}
      { User assigned name of the peak. Gets also assigned from Method peaks
        of the same X (in Window interval) during peaks autodetection. }
    Amount: TCompoundAmount;{<Enabled=1>}
      { When using calibration, here is calculated amount in moles (or
        whatever unit desired) of the compound. If the the peak is
        internal standard or the analysis is calibration standard,
        this value must be entered by user. }
    UsrPeakCoef: TUsrPeakCoef;{<Enabled=1>}
      { User defined multiplication coeficient used in calculation of
        Amount values. If equals 0, set to 1 automatically.  }
    BaseY1: TYValue;
      { Y coordinate of intersection of the left limit of the peak with the
        baseline }
    BaseY2: TYValue;
      { Y coordinate of intersection of the right limit of the peak with the
        baseline }
    GroupName: TPeakGroupName;{<Enabled=1>}
      { To what peaks group this peak belongs to. }
    Window: TXValue;{<Enabled=1 UserCoef=60 NumDec=2 Caption="Window [min]"
      Hint="In what interval the peaks are considered to be the same">}
      { If this peak is used as template peak (in method), then this value is
        used during autodetection of peaks in acquired data - if X value of
        autodetected peak (=newX) is in interval <thisX - window/2, thisX + window/2>,
        then the autodetected peak is considered to belong to he same compound
        - will copy some parameteres of this peak (PeakName, GroupName, Response).
        If this value is 0, then Method.MinPeakWidth value is used in autodetection. }
    Response: TResponse;{<Enabled=1>}
      { Response of the compound in the detector, e.g. extinction coeficient }
    InternalStandard: boolean;{<Enabled=1>}
      { Is this peak used as internal standard for calibration? }
    DataName: string;{<Enabled=1 Caption="Data name"
      Hint="In what data line the peak should be located (e.g.: B for blue line in AAA)">}
      { If more data acquired in data chromatogram (e.g. for different wavelengths)
        then hear can be the name of the data (should be the same as
        ULADType.DataName). If not specified, the first data will be assumed.
        Introduced in Chromulan v0.25 }
  end;

  PULPRRec = ^TULPRRec;
  {v0.69 SortExp changed from (X1+X2)/2 to X}
  {/v0.69}
implementation

end.
