unit MailerFrm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdMessage, ExtCtrls, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdMessageClient, IdSMTP,
  UtlType, PropUtl;

type
  TMailerForm = class(TForm)
    IdSMTP: TIdSMTP;
    Password: TLabeledEdit;
    UserID: TLabeledEdit;
    Host: TLabeledEdit;
    IdMessage: TIdMessage;
    Memo: TMemo;
    SendButton: TButton;
    OKButton: TButton;
    Recipient: TLabeledEdit;
    procedure FormCreate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure SendButtonClick(Sender: TObject);
  private
    { Private declarations }
    Rec: shortstring;
    procedure FormToComp;
    procedure CompToForm;
  public
    { Public declarations }
  end;

var
  MailerForm: TMailerForm;

implementation

{$R *.dfm}

procedure TMailerForm.FormCreate(Sender: TObject);
begin
  idMessage.Recipients.Add;
  ClassReadWriteIniFile(idSMTP, 0, '', true);{proputl}
  ConfigReadWriteValue(nil, rwRead, 'idSMTP', 'recipient', @Rec, ptString);
//  ClassReadWriteIniFile(idMessage.Recipients[0], 0, '', true);
  CompToForm;
end;

procedure TMailerForm.OKButtonClick(Sender: TObject);
begin
  FormToComp;
  ClassReadWriteIniFile(idSMTP, 0, '', false);
  ConfigReadWriteValue(nil, rwWrite, 'idSMTP', 'recipient', @Rec, ptString);
end;

procedure TMailerForm.FormToComp;
begin
  idSMTP.Host := Host.Text;
  idSMTP.Password := Password.Text;
  idSMTP.UserID := UserID.Text;

  Rec := Recipient.Text;
  idMessage.Recipients[0].Address := Rec;
  idMessage.Body := Memo.Lines;
end;

procedure TMailerForm.CompToForm;
begin
  Host.Text := idSMTP.Host;
  Password.Text := idSMTP.Password;
  UserID.Text := idSMTP.UserID;
  Recipient.Text := Rec;
  idMessage.Recipients[0].Address := Rec;
end;

procedure TMailerForm.SendButtonClick(Sender: TObject);
begin
  FormToComp;
  if not idSMTP.Authenticate then begin
    ShowMessage('Auth failed.');
    exit;
  end;
  idSMTP.Send(idMessage);
end;

end.
