unit CalibrationFrm;{v0.64}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids, ComCtrls,

  XStringGrid, ExtComDl, LsFileExplorer26, Graphu, Fitteru,

  ULRecTyp, ULObju, ULObjEditPanelu, ULStringGrid,

  UlanType, UlanGlob, Spectrum, CalDatau,
  UCPType, UCPObju, UCFType, UCFObju, UCFRType, UCFRObju,
  UCPLType, UCPLObju, UCPRType, UCPRObju;

type
  TCalibrationForm = class(TForm)
    SaveButton: TButton;
    FileNameEdit: TEdit;
    Label1: TLabel;
    FilesGrid: TULStringGrid;
    PeaksGrid: TULStringGrid;
    PeakLevelsGrid: TULStringGrid;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    AddBtn: TButton;
    DelBtn: TButton;
    DirTreeCombo: TLsDirTreeCombo26;
    FileListView: TLsFileListView26;
    ComposePeaksBtn: TButton;
    CreatePeakLevelBtn: TButton;
    ESaveDialog: TESaveDialog;
    SelectFileNameBtn: TButton;
    Image: TImage;
    UpdateButton: TButton;
    DefCurveFitTypeComboBox: TComboBox;
    Label5: TLabel;
    ResponseBaseComboBox: TComboBox;
    OriginUseComboBox: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    procedure SaveButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure FileNameEditChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DelBtnClick(Sender: TObject);
    procedure ComposePeaksBtnClick(Sender: TObject);
    procedure PeaksGridSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure CreatePeakLevelBtnClick(Sender: TObject);
    procedure SelectFileNameBtnClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure CalibrationTypeRadioGroupClick(Sender: TObject);
    procedure UpdateButtonClick(Sender: TObject);
  private
    { Private declarations }
    FCalData: TCalData;
    //FInitialDir: string;
    FGraph: TGraph;
    function GetGraph: TGraph;
    function GetCalData: TCalData;
    function GetCalDataName: string;
    { Update visual control according to the values in the CalData
      (called after CalData file changed) }
    procedure UpdateControls;
    procedure SetCalData(ACalData: TCalData);
    procedure SetCalDataName(const AFileName: string);
    procedure CheckCalData;
    procedure SetInitialDir(const ADir: string);
    function GetInitialDir: string;
    { Make visible/invisible controls used for multicalibration }
    procedure DecideWhatToSee;
    procedure GraphUpdate;

    { Called when active child in calibration peaks list changed }
    procedure UpdateFromCalPeak;
    procedure RecalculateCurve;
    procedure ControlsToObj;
  public
    { Public declarations }
    property CalData: TCalData read GetCalData write SetCalData;
    property CalDataName: string read GetCalDataName write SetCalDataName;
    {v0.67}
    property InitialDir: string read GetInitialDir write SetInitialDir;
    {/v0.67}
    property Graph: TGraph read GetGraph;
  end;

const
  CalibrationForm: TCalibrationForm = nil;

function ComposeCalibrationFormExecute(const ADirName: string;
  {/v0.65}AFileList: TStringList;
  {/v0.65} {v0.67}const {/v0.67 var} AFileName: string;
  {v0.67}{/v0.67 var} CalibrationType: TCalibType): boolean;

{v0.67}
function CalibrationFormOpen(const AFileName: string;
  AMode: TOpenMode): TCalibrationForm;
{/v0.67}

implementation

{$R *.DFM}

function ComposeCalibrationFormExecute(const ADirName: string;
  {/v0.65}AFileList: TStringList; {/v0.65}
  {v0.67}const {/v0.67 var }AFileName: string;
  {v0.67}{/v0.67 var} CalibrationType: TCalibType): boolean;
var
  ucfr: TUCFRObj;
  i: integer;
  {v0.67}
  cf: TCalibrationForm;
  {/v0.67}
begin
  cf := nil;
  if cf = nil then
    cf := TCalibrationForm.Create(Application);
  {v0.67}
  Result := false;
  try
  {/v0.67}
    cf.DefCurveFitTypeComboBox.ItemIndex := ord(CalibrationType);
    {v0.67}
    cf.CalDataName := AFileName;
    cf.InitialDir := ADirName;
    {/v0.67
    cf.FileNameEdit.Text := AFileName;
    cf.DirTreeCombo.OpenPath(ADirName);
    cf.FileListView.Directory := ADirName;
    cf.ESaveDialog.InitialDir := ADirName;}
    {v0.65}
    if (AFileList <> nil) and (AFileList.Count > 0) then begin
      for i := 0 to AFileList.Count - 1 do begin
        cf.CalData.FileAdd(AFileList[i]);
        {
        ucfr := TUCFRObj(cf.CalData.ULC_UCF.Add(UCFRID));
        ucfr.FileName := AFileList[i];}
      end;
    end;
    {/v0.65}
    {v0.67}
    cf.Show;
    Result := true;
    {/v0.67
    if cf.ShowModal = mrOK then begin

      CalibrationType := TCalibType(cf.CalibrationTypeRadioGroup.ItemIndex);
      AFileName := cf.FileNameEdit.Text;
      Result := true;
    end else begin
      Result := false;
    end;
    {/v0.67}
  {v0.67}
  except
    cf.Free;
  end;
  {/v0.67}
end;

function TCalibrationForm.GetInitialDir: string;
begin
  CheckCalData;
  Result := CalData.DefDir;
end;

{v0.67}
procedure TCalibrationForm.SetInitialDir(const ADir: string);
begin
  CheckCalData;
  CalData.DefDir := ADir;
  UpdateControls;
end;

function TCalibrationForm.GetCalDataName: string;
begin
  {v0.67}
  if CalData = nil then
    Result := ''
  else
  {/v0.67}
    Result := CalData.FileName;
end;

{/v0.67}
procedure TCalibrationForm.CheckCalData;
begin
  if FCalData = nil then begin
    FCalData := TCalData.Create('', omCreate);
    UpdateControls;
  end;
end;
{/v0.67}

procedure TCalibrationForm.SetCalDataName(const AFileName: string);
begin
  CheckCalData; // makes sure CalData <> nil
  if FileExists(AFileName) and (AFileName <> CalData.FileName) then begin
    CalData.SetFileName(AFileName, omRead);
  end else begin
    CalData.ChangeFileName(AFileName);
  end;
  UpdateControls;
end;

function TCalibrationForm.GetCalData: TCalData;
begin
  if FCalData = nil then begin
    {v0.67}{/v0.67 FCalData := TCalData.Create(FileNameEdit.Text, omRead);}

    //CreateOrOpenDataFile(CalDataName, FCalData);//: boolean;
    //if CalDataName = '' then
    //  FCalData.ULF.FileName := 'NONAME.CAL';
  end;
  Result := FCalData;
end;

procedure TCalibrationForm.SetCalData(ACalData: TCalData);
begin
  if FCalData = ACalData then
    exit;
  if FCalData <> nil then
    FCalData.Free;
  FCalData := ACalData;
  UpdateControls;
end;

procedure TCalibrationForm.SaveButtonClick(Sender: TObject);
begin
  {v0.67}
  CalData.DoFileSave;//ulobju
  UpdateControls;
  {/v0.67
  if FileNameEdit.Text = '' then begin
    ShowMessage('Enter name for the composed calibration file');
    ModalResult := 0;
    exit;
  end;
  CalData.Save;
  }
end;                                 // ulobju filescanner   filedropper


procedure TCalibrationForm.FormActivate(Sender: TObject);
begin
  DecideWhatToSee;
  UpdateControls;
  GraphUpdate;
end;

{v.65}
procedure TCalibrationForm.UpdateControls;
var adir: string;
begin
  if FCalData = nil then begin
    FilesGrid.Obj := nil;
    PeaksGrid.Obj := nil;
    PeakLevelsGrid.Obj := nil;
    FileNameEdit.Text := '';
    SaveButton.Enabled := false;
  end else begin
    FilesGrid.Obj := CalData.ULC_UCF;
    PeaksGrid.Obj := CalData.ULC_UCP;
    //PeakLevelsGrid.Obj := nil;
    UpdateFromCalPeak;

    FileNameEdit.Text := CalData.FileName;
    SaveButton.Enabled := true;//CalData.ULF.Modified;

    CalData.ULC_UCP.ObjDesc.FindFldDesc('CurveFitType').FillComboBoxItems(
      DefCurveFitTypeComboBox.Items
    );
    DefCurveFitTypeComboBox.ItemIndex := ord(CalData.ULC_UCP.CurveFitType);

    CalData.ULC_UCP.ObjDesc.FindFldDesc('ResponseBase').FillComboBoxItems(
      ResponseBaseComboBox.Items
    );
    ResponseBaseComboBox.ItemIndex := ord(CalData.ULC_UCP.ResponseBase);

    CalData.ULC_UCP.ObjDesc.FindFldDesc('OriginUse').FillComboBoxItems(
      OriginUseComboBox.Items
    );
    OriginUseComboBox.ItemIndex := ord(CalData.ULC_UCP.OriginUse);


    adir := CalData.DefDir;
    DirTreeCombo.OpenPath(adir);
    FileListView.Directory := adir;
    ESaveDialog.InitialDir := adir;
  end;
end;
{v0.65}

procedure TCalibrationForm.ControlsToObj;
begin
  CalData.ULC_UCP.CurveFitType := TCurveFitType(DefCurveFitTypeComboBox.ItemIndex);
  CalData.ULC_UCP.ResponseBase := TResponseBase(ResponseBaseComboBox.ItemIndex);
  CalData.ULC_UCP.OriginUse := TOriginUse(OriginUseComboBox.ItemIndex);
end;

procedure TCalibrationForm.AddBtnClick(Sender: TObject);
var
  f: TUCFRObj;
  v: TListItem;
begin
//tlistview
  v := FileListView.Selected;
  if v = nil then
    exit;
  CheckCalData;
  CalData.DefDir := FileListView.Directory;
  while v <> nil do begin
    CalData.FileAdd(v.Caption);
    v := FileListView.GetNextItem(v, sdAll, [isSelected]);
  end;
end;

procedure TCalibrationForm.FileNameEditChange(Sender: TObject);
begin
  {v0.67}
  CheckCalData;
  {/v0.67}
  CalData.ChangeFileName(FileNameEdit.Text);
end;

procedure TCalibrationForm.FormDestroy(Sender: TObject);
begin
  FCalData.Free;
  FCalData := nil;
  //CalibrationForm := nil;
end;

procedure TCalibrationForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

{v0.65}
procedure TCalibrationForm.DelBtnClick(Sender: TObject);
//var o: TULObj;
begin
  {v0.67}
  if FilesGrid.Obj <> nil then
  {/v0.67}
    FilesGrid.Obj.ChildsDelete(0, rfSelected);//ulrectyp
//  o := FilesGrid.Obj.ActiveChild;
//  if o <> nil then
//    o.Free;
end;

procedure TCalibrationForm.ComposePeaksBtnClick(Sender: TObject);
begin
  ControlsToObj;
  {v0.67}
  CheckCalData;
  {/v0.67}
  CalData.ComposePeaks(TCurveFitType(DefCurveFitTypeComboBox.ItemIndex),
    TResponseBase(ResponseBaseComboBox.ItemIndex),
    TOriginUse(OriginUseComboBox.ItemIndex)
  );
end;


procedure TCalibrationForm.PeaksGridSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  UpdateFromCalPeak;
end;

procedure TCalibrationForm.UpdateFromCalPeak;
var
  ucpr: TUCPRObj;
begin
  ucpr := TUCPRObj(PeaksGrid.Obj.ActiveChild);
  PeakLevelsGrid.Obj := TULObj(ucpr);

{  if ucpr.CurveFitType <> cfNone then
    CalibrationTypeRadioGroup.ItemIndex := 1
  else
    CalibrationTypeRadioGroup.ItemIndex := 0;}
  DecideWhatToSee;
  if ucpr <> nil then begin
    if ucpr.CurveFitType <> cfNone then
      RecalculateCurve;
  end;
end;

procedure TCalibrationForm.CreatePeakLevelBtnClick(Sender: TObject);
var
//  ucpl: TUCPLObj;
  o: TULObj;
begin
  o := PeakLevelsGrid.Obj;
  if o <> nil then begin
    {ucpl := TUCPLObj}(o.Add(UCPLID));
  end;
end;

{/v0.65}
procedure TCalibrationForm.SelectFileNameBtnClick(Sender: TObject);
begin
  if FileNameEdit.Text <> '' then
    ESaveDialog.FileName := FileNameEdit.Text;
  if ESaveDialog.Execute then begin
    FileNameEdit.Text := ESaveDialog.FileName;
    if FileExists(ESaveDialog.FileName) then begin
      CheckCalData;
      CalData.SetFileName(ESaveDialog.FileName, omRead);
      UpdateControls;
    end;
  end;
end;

procedure TCalibrationForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if FCalData <> nil then
    CanClose := FCalData.CanClose;
end;

{v0.67}
function CalibrationFormOpen(const AFileName: string; AMode: TOpenMode): TCalibrationForm;
begin
  Result := TCalibrationForm.Create(Application);
  with Result do begin
    CalData := TCalData.Create(AFilename, AMode);
{    if ExtractFilePath(AFileName) = '' then
      InitialDir := DataDir;}
    if AFileName = '' then
      InitialDir := DataDir;
    Result.FormStyle := fsMDIChild;
    Show;
  end;
end;
{/v0.67}

procedure TCalibrationForm.DecideWhatToSee;
var
  multi: boolean;
  ucpr: TUCPRObj;
begin
  multi := false;
  if (PeaksGrid.Obj <> nil) then begin
    ucpr := TUCPRObj(PeaksGrid.Obj.ActiveChild);
    multi := (ucpr <> nil) and (ucpr.CurveFitType <> cfNone);
  end;  

  PeakLevelsGrid.Visible := multi;
  CreatePeakLevelBtn.Visible := multi;
  Label4.Visible := multi;
  Image.Visible := multi;
  UpdateButton.Visible := multi;
end;

procedure TCalibrationForm.CalibrationTypeRadioGroupClick(Sender: TObject);
begin
  DecideWhatToSee;
end;

function TCalibrationForm.GetGraph: TGraph;
begin
  if FGraph = nil then begin
    FGraph := TGraph.Create(Self);
    FGraph.Control := Image
  end;
  Result := FGraph;
end;

procedure TCalibrationForm.GraphUpdate;
begin
  Graph.Draw;
end;

procedure TCalibrationForm.UpdateButtonClick(Sender: TObject);
begin
  UpdateFromCalPeak;
end;

procedure TCalibrationForm.RecalculateCurve;
var
  f: TFitter;              //tstringgrid
begin
  if CalData.FitActiveUCPR(f) then begin
    Graph.Func := f.Func;
    Graph.SetExpPoints(f.X, f.Y, f.PointCount);
    GraphUpdate;
  end;
end;

end.
