unit ControlFrm;{v0.55}
{ Window with controls for simulation of actions from devices }
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TControlForm = class(TForm)
    SendMarkButton: TButton;
    Button1: TButton;
    Button2: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SendMarkButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  ControlForm: TControlForm = nil;

procedure ControlWindowShow;

implementation
uses
  Processoru, Modulu, SpecForm, ULObj2XMLu, GpHugeF;

{$R *.DFM}

procedure ControlWindowShow;
begin
  if ControlForm = nil then begin
    ControlForm := TControlForm.Create(Application);
    ControlForm.Show;
  end else begin
    ControlForm.BringToFront;
  end;
end;

procedure TControlForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
  ControlForm := nil;
end;

procedure TControlForm.SendMarkButtonClick(Sender: TObject);
begin
  Processors.DoMark(Sender);
end;

procedure TControlForm.Button1Click(Sender: TObject);
var f: TSpectrumForm;
begin
  ULObj2XMLFile(Modules.ULD, 'Modules');
  if FindSpecForm(-1, f) then
    ULObj2XMLFile(f.ActiveAcqData.ULF, '');

end;

procedure TControlForm.Button2Click(Sender: TObject);
var
  rep: integer;
  i, start, time1, time2: integer;
  s, f: TStream;
begin
  time1 := 0;
  time2 := 0;
  rep := 10;

  for i := 0 to rep -1 do begin
    start := GetTickCount;
    f := TGpHugeFileStream.Create('chromulan.map', accRead);
    try
      s := TGpHugeFileStream.Create('hugeFileStream.tmp', accWrite);
      try
        s.CopyFrom(f, f.Size);
      finally
        s.Free;
      end;
    finally
      f.Free;
    end;
    time1 := time1 + GetTickCount - start;

    start := GetTickCount;
    f := TFileStream.Create('chromulan.map', fmOpenRead);
    try
      s := TFileStream.Create('FileStream.tmp', fmCreate);;
      try
        s.CopyFrom(f, f.Size);
      finally
        s.Free;
      end;
    finally
      f.Free;
    end;
    time2 := time2 + GetTickCount - start;
  end;
  ShowMessage('HugeStream: ' + IntToStr(time1) + ', FileStream: ' + IntToStr(time2) + ' [ms]');


end;

end.
