@echo off
:Test DIFF
: This CVSDO.BAT file is a "Quick quide" for using CVS commands in MS-Windows,
: it is usable directly as the commands caller.
:
: Commands are presented in the order they might be used:
:   import, checkout, add, remove, update, diff, status, commit, tag, log


: at least cvs command must be specified

if "%1" == "" goto help


if not "%2" == "" goto cont1
  :second param is empty, find out if it is OK

  if not "%1" == "import" goto cont2
    echo Project name must be specified for "import" command
    goto help
  :cont2

  if not "%1" == "checkout" goto cont3
    echo Project name must be specified for "checkout" command
    goto help
  :cont3

  if not "%1" == "add" goto cont 5
    echo File name must be specified for "add" command
    goto help
  :cont5
  if not "%1" == "remove" goto cont 6
    echo File name must be specified for "remove" command
    goto help
  :cont6
:cont1


 
: cvsproj is usually the same name as the name of the project's working root 
: directory
set cvsproj=%2


:CVSROOT should be set in AUTOEXEC.BAT e.g. by calling CVSENV.BAT 
:(located in this dir) only if using one CVSROOT directory.
:If using more CVS repositories, use -d command line option, e.g.:
:cvs -d :pserver:username@server.com:/usr/local/cvs ....
if not "%CVSROOT%" == "" goto cont

  set CVSROOT=:local:C:\CVSROOT
  md C:\CVSROOT 

  :some bug?, it requires existence subdir of the same name as CVSROOT
  md C:\CVSROOT\CVSROOT 

:cont

:rarely used parameters: vendortag, releasetag; set to values used
:for the first import of CHROMuLAN to CVS

set vendortag=jj
set releasetag=v0-77




goto %1

:====================================================================       
: 
:      IMPORT 
:
                    
: Create CVS project
:
: CurDir: root working directory of the new project, that
:         is not yet registered with CVS
: 
: After successful command execution backup the whole current directory
: rename it or erase it, and do not use it anymore for making any changes. 
: Call CHECKOUT to get the working copy from the CVS repository.

:import

cvs import -I ! -m "log import %cvsproj%" %cvsproj% %vendortag% %releasetag%

:command used to import CHROMuLAN:
:cvs import -I ! -m "log import %cvsproj%" %cvsproj% %vendortag% %releasetag%

:command used to import dmath from dmath subdir:
:cvs import -I ! -m "import dmath" dmath JDebord v1-0d

:expecting existence of %CVSROOT%\CVSROOT\cvswrappers file, where are
:specified binary files, the content of the file can be e.g.:
:*.exe -k 'b'
:*.dll -k 'b'
:*.res -k 'b'


goto end


:====================================================================
:
:      CHECKOUT
:

: Get working copy of the project from CVS repository
:
: CurDir: user home dir - project will be checked out (copied) from 
:         the CVS to the subdirectory named after the project
:
: abbr: co

cvs checkout %cvsproj%

:  Get working copy of the project at the state as of given tag (see TAG command):
:  (DONT DO IT IN YOUR WORKING DIRECTORY OR ITS PARENT DIRECTORY!
:  if you have some uncommited changes)
:cvs checkout [-d other_subdirname_then_cvsproj] -r Release_1995-05-01 %cvsproj%
goto end

:====================================================================
:
:      ADD
:
: Add new file/directory to the project. File will really get to the 
: CVS repository during next commit, directory immediatelly

cvs add %2

: add binary file (pict.jpg) - suppress line end conversions, keywords expansion:
:   cvs -kb add pict.jpg
:
: add file (x.txt) and suppress keyword expansion only:
:   cvs -ko add x.txt

goto end

:====================================================================
:
:      REMOVE
:
: remove file from the current working project
: and CVS repository (next commit will remove it from there)
: 

del %2
cvs remove %2

:  remove subdirectory - remove all files from it explicitly
:cd subdir
:del file1; del file2;...
:cvs remove file1 file2 ...
:cvs commit -m "removed all files" file1 file2 ...
:cd ..
:  removes empty subdirectories from the working dir:
:cvs  update -P

goto end

:====================================================================
:
:      STATUS
:
: display status of file/all files in current working directory
: comparing them with files in CVS repository
:

cvs status %2
goto end


:====================================================================
:
:      DIFF
:

:  will display difference between specified/all files in the current
:  working directory and the files in the CVS repository
:cvs -Q diff -c [[subdir]filename]   is often used for better readability

cvs diff %2

:  comparing two revisions (1.3 and 1.4) of the same file (hello.c):
:cvs diff -c -r 1.3 -r 1.4 hello.c
:  compare current version with that as of the given tag (see TAG command):
:cvs diff -c -r Release-1995-05-01 hello.c

goto end


:====================================================================
:
:      UPDATE
:
:
: will update the file/files in the current working directory with
: changes commited by others to the CVS repository since last
: checkout or update
:
: abbr: up

cvs update %2

:  get old version (1.3) of file (hello.c) from cvs repository
:  to standard output (-p), suppressing messages (-Q), redirecting
:  to some other file (e.g. also hello.c to rewrite it with the old version):
:cvs -Q update -p -r 1.3 hello.c > hello.c

:  revert to old version (faster, easier then the above way, especially
:  for more files), 1.4 is the current version, reverting to 1.3,
:  applies patches to current version from the versions specified in -j
:  options (max 2):
:cvs update -j 1.4 -j 1.3 hello.c

: bring all new subdirectories from repository:
:cvs update -d


:  revert to the state as of given date/time=set "sticky date":
:  (if not GMT specified, local time is used; but in CVS repository 
:  all date/times are GMT)
:cvs -q update -D "1999-04-19 23:59:59 GMT"
:  since this command completed, "cvs update" will update just up to the
:  "sticky date" - specified in -D option;
:
:  clear sticky date/tags (with -A option):
:cvs -q update -A

goto end

:====================================================================
:
:      COMMIT
:
: transfers all changes in specified file/all files in current working 
: project directory to CVS repository
:
: abbr: ci

cvs commit -m "made changes xxx" %2
goto end


:====================================================================
:
:      LOG
:
: display information about file(s) changes history 
:
cvs log %2
goto end


:====================================================================
:
:      TAG
:
: mark all files in CVS repository for the current project with some
: kind of whole project's revision/version tag (for future retrieving
: of this project version). The actual tag value must be specified
: as the second parameter. E.g.: cvs tag Release-1995-02-01
: tag must start with a letter, can not contain spaces, dots,.. (only
: letter, number, underscore, dash)
:
cvs tag %2

: create a branch of the old version of the project (after checking it out 
: to other working dir)
:cvs tag -b Release-1999_05_01-bugfix-branch
goto end

:help
echo Usage: cvsdo command [projectname|file name]

:end