unit ComInfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  CommInt;

type
  TCommInfoForm = class(TForm)
    Memo: TMemo;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowInfo(AComPort:TComm);
  end;

var
  CommInfoForm: TCommInfoForm;

procedure ShowPortInfo(AComPort:TComm);

implementation

{$R *.DFM}

procedure TCommInfoForm.ShowInfo(AComPort:TComm);
  procedure w(s:string);
  begin
    Memo.Lines.Add(s);
  end;
var DCB:TDCB;
  o:TCommOption;
  s:string[1];
begin {commint}
  if not AComPort.Enabled then begin
    ShowMessage(AComPort.DeviceName + ' not opened.');
    exit;
  end;
  Memo.Lines.Clear;
  if not GetCommState(AComPort.Handle, DCB) then begin
    ShowMessage('GetComState failed');
    exit;
  end;
  for o := low(TCommOption) to high(TCommOption) do begin
    if o in AComPort.Options then
      s := '+'
    else
      s := '-';
    w(CommOptionNames[o] + ' ' + s);
  end;
  ShowModal;
end;

procedure ShowPortInfo(AComPort:TComm);
begin
  if CommInfoForm <> nil then
    CommInfoForm.ShowInfo(AComPort);
end;

initialization
  CommInfoForm := nil;
end.
