unit DebStrmu;{v0.76}

interface
uses
  Classes;
procedure DebStreamOpen;
procedure DebStreamLog(const msg: string);
procedure DebStreamClose;

implementation
const
  DebStreamFileName = 'DebStream.LOG';
var
  DebStream: TFileStream = nil;
  DebStreamCnt: longint = 0;

procedure DebStreamOpen;
begin
  if DebStreamCnt = 0 then begin
    DebStream := TFileStream.Create(DebStreamFileName, fmCreate);
    DebStream.Seek(0, soFromEnd);
  end;
  inc(DebStreamCnt);
  {tfilestream exelogu string}
end;

procedure DebStreamLog(const msg: string);
begin
  DebStream.WriteBuffer(PChar(msg)^, length(msg));
  DebStream.Write(#13#10, 2);
end;

procedure DebStreamClose;
begin
  if DebStreamCnt = 0 then
    exit;
  dec(DebStreamCnt);
  if DebStreamCnt = 0 then begin
    DebStream.Free;
    DebStream := nil;
  end;
end;
end.
