unit IniClassu;

interface
uses
  SysUtils, Classes,
  PropUtl, WinUtl;

type
  TIniClass = class(TComponent)
  protected
    FFirstIniPropIndex: integer;
    FIniFileName: string;
    FAutoSave: boolean;
    procedure SetDefault; virtual;
    procedure Save;
    procedure Load;
  public
    constructor Create(AOwner: TComponent); reintroduce;
    destructor Destroy;override;
  published
    { Save all published properties to .ini file upon Destroy? }
    property AutoSave: boolean read FAutoSave write FAutoSave;
  end;

implementation

constructor TIniClass.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  SetDefault;
  Load;
end;

procedure TIniClass.Load;
begin
  ClassReadWriteIniFile(Self, FFirstIniPropIndex, FIniFileName, true);
end;

procedure TIniClass.Save;
begin
  ClassReadWriteIniFile(Self, FFirstIniPropIndex, FIniFileName, false);
end;

procedure TIniClass.SetDefault;
begin
  AutoSave := true;
end;

destructor TIniClass.Destroy;
begin
  if AutoSave or (not FileExists(FindIniFile)) then begin
    Save;
  end;
  inherited;
end;

end.
