unit ObjList;
{ TList descendant, that calls Free for each Item from Clear or Destroy
  methods (no other method frees the items!!!) }
interface
uses Classes;

type
  TObjList = class(TList)
    destructor Destroy;override;
    { Delete and destroy item form ObjList }
    procedure ObjFree(Item: TObject);
    procedure Clear; override;
  end;

implementation

procedure TObjList.Clear;
var
  i: integer;
begin
  for i := 0 to Count - 1 do
    TObject(Items[i]).Free;
  inherited;
end;

destructor TObjList.Destroy;
begin
  Clear;
  inherited;
end;

procedure TObjList.ObjFree(Item: TObject);
var i: integer;
begin
  if Item = nil then
    exit;
  i := IndexOf(Item);
  if i >= 0 then begin
    Delete(i);
  end;
  Item.Free;
end;

end.
