unit OneEditPanel;
{
  (C) 2000 - 2002 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TPanelShape = (psCircle, psNormal);
  TOneEditPanel = class(TPanel)
  private
    { Private declarations }
    {FValue: string;}
    FShape: TPanelShape;
    FLabels: TStringList;
    FNamesAndValues: boolean;
  protected
    { Protected declarations }
    procedure Paint;override;
    procedure SetValue(const AValue:string);
    function GetValue: string;
    procedure SetShape(AShape: TPanelShape);
    procedure SetLabels(ALabels: TStringList);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent);override;
    destructor Destroy;override;
  published
    { Published declarations }
    property Value: string read GetValue write SetValue;
    property Shape: TPanelShape read FShape write SetShape;
    property Labels: TStringList read FLabels write SetLabels;
    property NamesAndValues: boolean read FNamesAndValues write FNamesAndValues;
  end;

procedure Register;

implementation

constructor TOneEditPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FLabels := TStringList.Create;
end;

procedure TOneEditPanel.SetLabels(ALabels: TStringList);
begin
  if FLabels = nil then
    FLabels := TStringList.Create;
  FLabels.Assign(ALabels);
end;

destructor TOneEditPanel.Destroy;
begin
  FLabels.Free;
  inherited Destroy;
end;

procedure TOneEditPanel.Paint;
const
  dist1 = 2;
  dist2 = 4;
begin
  inherited Paint;
  case FShape of
    psCircle: begin
      Canvas.Ellipse(dist1, dist1, Width - dist1, Height - dist1);
      Canvas.Ellipse(dist2, dist2, Width - dist2, Height - dist2);
    end;
  end;
end;

function TOneEditPanel.GetValue: string;
begin
  Result := Caption;
end;

procedure TOneEditPanel.SetValue(const AValue:string);
var
  s, line: string;
  i, j, code: integer;
begin
  s := AValue;
  if (FLabels <> nil) and (FLabels.Count > 0) then begin
    if FNamesAndValues then begin
      for i := 0 to FLabels.Count - 1 do begin
        line := FLabels[i];
        j := pos('=', line);
        if j > 0 then begin
          if copy(line, 1, j - 1) = AValue then begin
            s := copy(line, j + 1, length(line));
            break;
          end;
        end;
      end;
    end else begin
      Val(AValue, i, code);
      if code = 0 then begin
        if (i >= 0) and (i < FLabels.Count) then
          s := FLabels[i];
      end;
    end;
  end;
  Caption := s;
end;

procedure TOneEditPanel.SetShape(AShape: TPanelShape);
begin
  if AShape <> FShape then begin
    FShape := AShape;
    Invalidate;
  end;
end;

procedure Register;
begin
  RegisterComponents('Chromulan', [TOneEditPanel]);
end;

end.
