unit PickFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TPickForm = class(TForm)
    ListBox: TListBox;
    procedure ListBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure ListBoxDblClick(Sender: TObject);
  private
    { Private declarations }
    FItemIndex: integer;
    function GetList: TStrings;
    procedure SetList(AList: TStrings);
    procedure SetItemIndex(AValue: integer);
  public
    { Public declarations }
    property List: TStrings read GetList write SetList;
    property ItemIndex: integer read FItemIndex write SetItemIndex;
  end;

function PickFromList(const ACaption: string; AList: TStrings; ADefItemIndex: integer): integer;

var PickForm: TPickForm;

implementation

{$R *.DFM}

procedure TPickForm.ListBoxKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    vk_Escape: begin
      ModalResult := mrCancel;
    end;
    vk_Return: begin
      ItemIndex := ListBox.ItemIndex;
      ModalResult := mrOK;
    end;
  end;
end;

procedure TPickForm.SetList(AList: TStrings);
var i: integer;
begin
  ListBox.Items.Clear;   {tlistbox}
  for i := 0 to AList.Count - 1 do
    ListBox.Items.AddObject(AList[i], AList.Objects[i]);
end;

procedure TPickForm.SetItemIndex(AValue: integer);
begin
  if (AValue >= 0) and (AValue < ListBox.Items.Count) then begin
    ListBox.ItemIndex := AValue;
    {v0.55}
    FItemIndex := AValue;
    {/v0.55}
  end {v0.56} else if (AValue = -1) then begin
    FItemIndex := -1;
  end{/v0.56};
end;

function TPickForm.GetList: TStrings;
begin
  Result := ListBox.Items;{tlistbox}
end;

procedure TPickForm.FormCreate(Sender: TObject);
begin
  FItemIndex := -1;
end;

procedure TPickForm.ListBoxDblClick(Sender: TObject);
begin
  FItemIndex := ListBox.ItemIndex;
  ModalResult := mrOK;
end;

function PickFromList(const ACaption: string; AList: TStrings; ADefItemIndex: integer): integer;
var f: TPickForm;
begin
  f := TPickForm.Create(nil);
  try
    f.Caption := ACaption;
    f.List := AList;
    f.ItemIndex := ADefItemIndex;
    f.ShowModal;
    Result := f.ItemIndex;
  finally
    f.Free;
  end;
end;

end.
