unit UtlType;
{ Replaces MyType, TVType, DPMIType, ConfType for Win32 applications.
  Generic - non windows dependent types; NO DATA, NO CODE }

interface
uses Messages;
{ConfType}
const
  IniExt = '.INI';
  NonsenseString = '#@#x$%$$x.';
    { used as default for reading from ini file }
{rwXXXX}
type
  TReadWrite = (rwRead, rwWrite, rwWriteFlush);
  { Parameter for PropUtl.ConfigReadWrite function  }
{/rwXXXX}
{/ConfType}

{TVType}
{ Type conversion records }
  { in SysUtils
  WordRec = record
    Lo, Hi: Byte;
  end; }
type
  Int16 = SmallInt;

  LongRec = record
    case Int16 of
    0:(Lo, Hi: Word;);
    1:(Byte:array[0..3]of byte);
    2:(Word:array[0..1]of word);
  end;

  PtrRec = record
    Ofs, Seg: Word;
  end;
{/TVType}

type

  SetOfByte = set of byte;
  PSetOfByte = ^SetOfByte;
  SetOfChar = set of char;
  PSetOfChar = ^SetOfChar;


  PLongint = ^Longint;
  PByte = ^byte;
  PWord = ^word;
  PInteger = ^Int16;
  PBoolean = ^boolean;
  PPointer = ^pointer;
  POneChar = ^char;
  PReal = ^real;

  TVarName = string[20];
  TLineStr = string;
  TErrorProc = procedure(S:String);
  string1 = string[1];
  TRealMoney = real;

const
  MaxBufSize =  65521;  { The maximum amount that can be allocated
                          to a pointer }
  MaxByte = 255;
  MaxWord = 65535;
  MaxBufferSize = 65521;
  MaxInteger = MaxInt;
  MaxShortInt = 127;
  MinShortInt = -128;
  MinInteger = -32768;
  MaxReal = 1.0E32;
  MinReal = -1.0E32;
  {MaxLongint in system}

type
  TBufSize = word;{may be longint later?}
  TBuf = array[0..MaxBufSize - 1] of byte;
  PBuf = ^TBuf;

  PByteBuffer = ^TByteBuffer;
  TByteBuffer = array[0..pred(MaxWord)] of byte;
  PCharBuffer = ^TCharBuffer;
  TCharBuffer = array[0..pred(MaxWord)] of char;

  TProcessID = word;{type of HInstance}
  {$IFDEF WIN32}
  TInstance = Longint;
  {$ELSE}
  TInstance = word;
  {$ENDIF}

{v0.45}
  TLongByteArray = array[0..MaxInt - 1] of byte;
  PLongByteArray = ^TLongByteArray;
{/v0.45]

{WinType begin}
type

  PathStr = string;
  DirStr = string;
  ExtStr = string;
  NameStr = string;
const
  rt_RCData = PChar(10);
{WinType end}

const
{bmXXXX}
  bmResize = $01;
  bmZoom = $02;
  bmClose = $04;
  bmHelp = $08;
  bmPrint = $10;
  bmLocalMenu = $20;

  bmAppendRecord = $0100;
  bmEditRecord = $0200;
  bmFindRecord = $0400;
  bmDeleteRecord = $0800;
  bmReindex = $1000;
  bmPack = $2000;
  bmNext = $4000;
  bmPrev = $8000;
  bmChangeDateRange = $10000;{for rangedbf files}
  bmNewDateRange = $20000;
{/bmXXXX}

const
  {Message procedures types (for use in msg.SetMsgProc)}
  mtShowMessage = 1;
  mtProgressBox = 2;
  mtSysError = 3;
  mtSysOutput = 4;
  mtAll = 10;

type
  THelpCtx = word;

  TMsgProcType = Int16;
  TShowMessageResult = word;
  TShowMessageOptions = longint; {.. see smXXXX constants}
  TShowMessageFn = function(msg:string; options:TShowMessageOptions; hc:THelpCtx):TShowMessageResult;

  PShowMessageRec = ^TShowMessageRec;
  TShowMessageRec = record
    msg:string;
    options:TShowMessageOptions;
    hc:THelpCtx;
    ShouldDispose:boolean;{show receiver of cmShowMessage dispose this
      record?}
  end;{used with connection to cmShowMessage message }

  TProgressBox = pointer;

  {v0.24} {/v0.24

  TProgressBox = pointer;
  TProgressBoxResult = longint;
  TProgressBoxAction = Int16;
  TProgressBoxFn = function(var AProgressBox:TProgressBox; what:TProgressBoxAction; const Msg:string;
    X,Y:longint):TProgressBoxResult;

  TSysErrorProc = procedure(msg:string);
  TSysOutputProc = procedure(msg:string);
  }
  TMenuItemName = string[10];
  TViewName = string[80];

  TRectangle = record
    Left, Top, Width, Height:Int16;
  end;
  TScreenLine = string[80];

{emXXXX - edit menu flags, returned as response to WM_APPMESSAGE cmQueryEditMenu }
const
   emCut = 1;
   emCopy = 2;
   emPaste = 4;
{/emXXXX}

{INI Sections}
const
  GuiSection= '[GUI]';
  EnvSectionName = '[Environment]';
  DBSectionName = '[DB]';
{/INI Sections}

const

{for Progress box}
{pbXXXX}
  pbShow = 30;
  pbHide = 31;
  pbUpdate = 32;
  pbMsg = 33;
  pbCanceled = 34; {fn ProgressBox() <> 0 if canceled}
  pbCancel = 35;
  pbTop = 36;{put the window in front}
  pbStayOnTopOn = 37;{next opened progresses box will be always on top}
  pbStayOnTopOff = 38;{switch off the always on top mode for next opened boxes}
{/pbXXXX}

{for ShowMessage box:}
{smXXXX}
{what kind of message:}
  smWarning      = $0000;       { Display a Warning box }
    smWarn       = smWarning;
  smError        = $0001;       { Display a Error box (adds there OK button)}
  smInformation  = $0002;       { Display an Information Box }
    smInfo       = smInformation;
  smConfirmation = $0003;       { Display a Confirmation Box }
    smConfirm    = smConfirmation;

  {specialized messages:}
  smOutOfMemory  = $0008;
    smOOM        = smOutOfMemory;
  smFileNotFound = $0009;
  smFileExistsOverwrite = $000A;
  smFileModifiedSave = $000B;

{what buttons to insert to message box}
  smYes          = $0100;       { Put a Yes button into the dialog }
  smNo           = $0200;       { Put a No button into the dialog }
  smOK           = $0400;       { Put an OK button into the dialog }
  smCancel       = $0800;       { Put a Cancel button into the dialog }

  smDefaultNo    = $1000;       { make No button default (in yes/no boxes)}
  smDefaultCancel = $2000;      { make Cancel button default (in OK/Cancel boxes)}

  smYesNo        = smYes + smNo;
  smNoYes        = smYes + smNo + smDefaultNo;
  smYesNoCancel  = smYes + smNo + smCancel;{ Standard Yes, No, Cancel dialog }
  smOKCancel     = smOK + smCancel;        { Standard OK, Cancel dialog }

{/smXXXX}

{File Attributes (dos unit)}
  faReadOnly      =  $01;
  faHidden        =  $02;
  faSysFile       =  $04;
  faVolumeID      =  $08;
  faDirectory     =  $10;
  faArchive       =  $20 ;
  faAnyFile       =  $3F;
{/File Attributes}

type
  DateTime = record
    Year,Month,Day,Hour,Min,Sec: Word;
  end;

  FileRec = record
    Handle: Word;
    Mode: Word;
    RecSize: Word;
    Privat: array[1..26] of Byte;
    UserData: array[1..16] of Byte;
    Name: array[0..79] of Char;
  end;



const
 fmClosed = $D7B0;
 fmInput  = $D7B1;
 fmOutput = $D7B2;
 fmInOut  = $D7B3;

const
{  DefaultProgressBox:pointer = pointer(1); in mylib}
  NoProgressBox = nil;

{Windows messages}
const
  WM_APPMESSAGE = WM_USER + 1129;
    { see MyType (4000..4999, 5000..5999); ULRecTyp (7000-7999), AppType (9000..9999)
      for already used commands with this message }

{/Windows}
{cmXXXX commands sent by WM_APPMESSAGE messages}
const
  cmBUser = 5000;

  cmLogEvent = cmBUser + 450;
  { Sent to activeform to find out what items of Edit menu
    it supports - active form should return mask of emXXXX flags (see below) }
  cmQueryEditMenu = cmBUser + 451;
  { For invoking local menu. }
  cmLocalMenu = cmBUser + 452;
  
  cmDBGridCellClicked = cmBUser + 453;

  { Used in GuiUtl.PostEvent(Application.MainForm.Handle, WM_APPMESSAGE, cmActionExecute, integer(TAction)) }
  cmActionExecute = cmBUser + 500;
{/cmXXXX}

type
  TFileNamePart = word;
  TFileProperty = Int16;
{fpXXXX GetFileNamePart, GetFilePropInt }
const
  fpBaseName = 1;
  { Pouvno pro oznaen jmna souboru bez adrese a bez ppony
    ve funkci GetFileNamePart }
  fpExt = 2;
  { Pouvno pro oznaen jmna ppony souboru ve funkci GetFileNamePart }
  fpDir = 3;
  { Pouvno pro oznaen jmna adrese souboru ve funkci GetFileNamePart,
    funkce vrac adres vetn lomtka, pouijte parametr
    (fpDir + fpDelBackSlash) pokud chcete jmno adrese bez lomtka }
  fpDirAndBaseName = 4;
  { Pouvno pro oznaen jmna souboru bez ppony ve funkci GetFileNamePart }
  fpBaseNameAndExt = 5;
  { Pouvno pro oznaen jmna souboru bez adrese ve funkci GetFileNamePart }
  fpUtlFile = 6;
  { Parameter pro funkci GetFileNamePart, funkce pak vrac pln jmno
    souboru, je je hledn v adresch: aktuln, exe, path }
  fpExpand = 7;
  { Parametr pro funkci GetFileNamePart, funkca pak vrac
    stejn vsledek jako Pascalovsk funkce FExpand }
  fpTempFileNameInDir = 8;
  { Parametr pro funkci GetFileNamePart, funkce vrac jmno
    doasnho souboru v adresi AFileName }
  fpFileSize = 30;
  { Parametr pro funkci GetFilePropInt, fce vraci velikost
    souboru v bytech }
  fpFileAttr = 31;
  { Parametr pro funkci GetFilePropInt, fce vraci atributy
    souboru (viz DOS konstanty) }
  fpFileTime = 32;
  { Parametr pro funkci GetFilePropInt, fce vraci pakovany
    datum/cas souboru }
  fpFileExists = 33;
  { Parametr pro funkci GetFilePropInt, fce vraci 1 kdyz
    soubor existuje, 0 pokud ne }
  fpAddBackSlash = $100;
  { Pouvno pro pipojen (i kontrolu pipojen) zptnho lomtka
    na konec jmna adrese ve funkci GetFileNamePart }
  fpDelBackSlash = $200;
  { Pouvno pro odstrann (i kontrolu odstrann) zptnho
    lomtka na konci jmna adrese ve funkci GetFileNamePart }
{/fpXXXX}
type
  TAutoFocus = byte;
const
{afXXXX}
  {AutoFocus constants for TGroup.AutoFocus}
  afAuto = 1; {default, pri hide nebo show se automaticky
    vybr dal view }
  afNone = 2; {pi hide-show se jako aktivni view nastavi nil a
    zru bval vybran view}
  afIgnore = 3; {pi hide-show se a s aktivnm View nedje vbec nic}

{/afXXXX}
type
  TPropertyType = byte;
  { Pascalovsk typ hodnoty, parametru, vlastnosti : ptChar,
    ptWord, ptInteger, ptByte, ptLongint, ptPChar, ptString, ptReal;
    pouvno nap. u funkce ConfigReadWrite }
const
{ptXXXX PropertyTypes}
  ptNone = ord('0');
  {Viz TPropertyType}
  ptChar = ord('c');
  {Viz TPropertyType}
  ptWord = ord('w');
  ptInt16 = ord('i');
  ptInteger = ptInt16;
  ptByte = ord('b');
  ptLongint = ord('l');
  ptInt32 = ptLongint;
  ptPChar = ord('p');
  ptString = ord('s');{@shortstring}
  ptReal = ord('r');{@real}
  ptHex = ord('h'); { Word in form of the hexadecimal stringu }
  ptMethod = ord('m'); { pointer to procedure  }
  {v0.39}{/v0.39 ptPString = ord('t');}{@@shortstring}
  ptSingle = ord('g');
  {v0.40}
  ptDouble = ord('d');
  {/v0.40}
{/ptXXXX}
  PropertyTypes{:set of byte} = [ptChar, ptWord, ptInteger, ptByte, ptLongint,
    ptPChar, ptString, ptReal, ptHex, {v0.39}{/v0.39 ptPString,} ptSingle
    {v0.40}, ptDouble{/v0.40}];

type
  TFixString = byte;{see fsXXXX}
  TPadString = byte;{see psXXXX}

const
{fsXXXX FixString}
  fsTrim = 0;
  { Parametr pro funkci FixString. Funkce vrt string
    zbaven potench a koncovch mezer.}
  fsLTrim = 1;
  { Parametr pro funkci FixString. Funkce vrt string
    zbaven potench mezer.}
  fsRTrim = 2;
  { Parametr pro funkci FixString. Funkce vrt string
    zbaven koncovch mezer.}
  fsTrimLZero = 3;
  { Parametr pro funkci FixString. Funkce vrt string
    zbaven potench mezer a nul.}
  fsUpcase = 4;
  { Parametr pro funkci FixString. Funkce vrt string
    peveden na velk psmena (ne podle kdov strnky, pouze
    anglick psmena) }
{/fsXXXX}

{psXXXX pad string constants}
  psPad = 0;    {For PadString, add spaces from right}
  psLPad = 1;   {For PadString, add spaces from left}
  psCenter = 2; {For PadString, add spaces from both sides}
  psRight = 3;  {For PadString, cuts Len chars from right (= copy(S, length(S) - right + 1, right)}
  psLeft = 4;   {For PadString, cuts Len chars from left (= copy(S, 1, Len)}
  psLZero = 5;  {For PadString, add '0' from left }
  psRZero = 6;  {For PadString, add '0' from right }
{/psXXXX}

{dsXXXX defined states (of anything)}
const
  dsUnknown = 2;  { dont know if defined or undefined => find out}
  dsUndefined = 0;{ found out that undefined }
  dsDefined = 1;  { found out that defined }
{/dsXXXX}

{stXXXX BP TStream errors }
  stOk         =  0;              { No error }
  stError      = -1;              { Access error }
  stInitError  = -2;              { Cannot initialize stream }
  stReadError  = -3;              { Read beyond end of stream }
  stWriteError = -4;              { Cannot expand stream }
  stGetError   = -5;              { Get of unregistered object type }
  stPutError   = -6;              { Put of unregistered object type }
{/stXXXX}

const
  BitsPerByte = 8;
{v0.44}
type
  TDateTimePart = (dtMilisecond, dtSecond, dtMinute, dtHour, dtDay, dtMonth, dtYear);
  TDateTimeParts = set of TDateTimePart;
{/v0.44}
{v0.45}
  TDateTimeArray = array[TDateTimePart] of word;
{dkXXXX }
type
  TDataDispKind = ( { how to show data to Usr }
    dkHexa,
    dkDecimal,
    dkChar,
    dkBCD
  );
{/dkXXXX }
{/v0.45}

{v0.47}
{wdXXXX}
type
  TWeekDay = (wdNone, wdSunday, wdMonday, wdTuesday,
    wdWednesday, wdThursday, wdFriday, wdSaturday);
    { ord(TWeekDay) corresponds to the Result of
      SysUtils DayOfWeek function }
  TWeekDays = set of TWeekDay;
{/wdXXXX}

{/v0.47}


{v0.49}
type
  TDevDrvStartType = (stBoot, stSystem, stAuto, stDemand, stDisabled);
  {
  WinSvc.pas:
  SERVICE_BOOT_START            = $00000000;
  SERVICE_SYSTEM_START          = $00000001;
  SERVICE_AUTO_START            = $00000002;
  SERVICE_DEMAND_START          = $00000003;
  SERVICE_DISABLED              = $00000004;
  }
{/v0.49}
  TPresenceState = (psUnknown, psPresent, psNotPresent);
{v0.50}
const
  NumberChars = ['0'..'9','-','.','e','E','+'];
  HoursPerDay = 24;
{/v0.50}

const
  LogSec = '[Log]';

{v0.64}
const
  TabChar = #9;
{/v0.64}
{v0.70}
type
  TDateString = string[8];
{/v0.70}  
implementation
end.
