unit XGridFrm;
{
  (C) 2000 - 2001 Jindrich Jindrich, Pavel Pisa, PiKRON Ltd.

  Originators of the CHROMuLAN project:

  Jindrich Jindrich - http://www.jindrich.com
                      http://orgchem.natur.cuni.cz/Chromulan/
                      software developer, project coordinator
  Pavel Pisa        - http://cmp.felk.cvut.cz/~pisa
                      embeded software developer
  PiKRON Ltd.       - http://www.pikron.com
                      project initiator, sponsor, instrument developer

  The CHROMuLAN project is distributed under the GNU General Public Licence.
  See file COPYING for details.

  Originators reserve the right to use and publish sources
  under different conditions too. If third party contributors
  do not accept this condition, they can delete this statement
  and only GNU license will apply.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, Grids, XStringGrid;

type
  TXGridForm = class(TForm)
    Grid: TXStringGrid;
    PopupMenu: TPopupMenu;
    CopyToClipboard: TMenuItem;
    SwitchColsRows: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CopyToClipboardClick(Sender: TObject);
    procedure SwitchColsRowsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  XGridForm: TXGridForm;

implementation

{$R *.DFM}

procedure TXGridForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TXGridForm.CopyToClipboardClick(Sender: TObject);
begin
  Grid.CopyToClipboard;
end;

procedure TXGridForm.SwitchColsRowsClick(Sender: TObject);
begin
  Grid.SwitchColsRows;
end;

end.
